/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Comparer;
import com.bestvike.function.DecimalFunc1;
import com.bestvike.function.DoubleFunc1;
import com.bestvike.function.FloatFunc1;
import com.bestvike.function.Func1;
import com.bestvike.function.IntFunc1;
import com.bestvike.function.LongFunc1;
import com.bestvike.function.NullableDecimalFunc1;
import com.bestvike.function.NullableDoubleFunc1;
import com.bestvike.function.NullableFloatFunc1;
import com.bestvike.function.NullableIntFunc1;
import com.bestvike.function.NullableLongFunc1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.math.BigDecimal;
import java.util.Comparator;

public final class MinBy {
    private MinBy() {
    }

    public static <TSource> TSource minByInt(IEnumerable<TSource> source, IntFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = e.current();
            int key = keySelector.apply(value);
            while (e.moveNext()) {
                TSource curValue = e.current();
                int curKey = keySelector.apply(curValue);
                if (curKey >= key) continue;
                value = curValue;
                key = curKey;
            }
        }
        return value;
    }

    public static <TSource> TSource minByIntNull(IEnumerable<TSource> source, NullableIntFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            Integer key;
            do {
                if (e.moveNext()) continue;
                TSource TSource = null;
                return TSource;
            } while ((key = keySelector.apply(value = e.current())) == null);
            while (e.moveNext()) {
                TSource curValue = e.current();
                Integer curKey = keySelector.apply(curValue);
                if (curKey == null || curKey >= key) continue;
                value = curValue;
                key = curKey;
            }
        }
        return value;
    }

    public static <TSource> TSource minByLong(IEnumerable<TSource> source, LongFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            value = e.current();
            long key = keySelector.apply(value);
            while (e.moveNext()) {
                TSource curValue = e.current();
                long curKey = keySelector.apply(curValue);
                if (curKey >= key) continue;
                value = curValue;
                key = curKey;
            }
        }
        return value;
    }

    public static <TSource> TSource minByLongNull(IEnumerable<TSource> source, NullableLongFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            Long key;
            do {
                if (e.moveNext()) continue;
                TSource TSource = null;
                return TSource;
            } while ((key = keySelector.apply(value = e.current())) == null);
            while (e.moveNext()) {
                TSource curValue = e.current();
                Long curKey = keySelector.apply(curValue);
                if (curKey == null || curKey >= key) continue;
                value = curValue;
                key = curKey;
            }
        }
        return value;
    }

    public static <TSource> TSource minByFloat(IEnumerable<TSource> source, FloatFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            float key;
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            if (Float.isNaN(key = keySelector.apply(value = e.current()))) {
                TSource TSource = value;
                return TSource;
            }
            while (e.moveNext()) {
                TSource curValue = e.current();
                float curKey = keySelector.apply(curValue);
                if (curKey < key) {
                    value = curValue;
                    key = curKey;
                    continue;
                }
                if (!Float.isNaN(curKey)) continue;
                TSource TSource = curValue;
                return TSource;
            }
        }
        return value;
    }

    public static <TSource> TSource minByFloatNull(IEnumerable<TSource> source, NullableFloatFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            Float key;
            do {
                if (e.moveNext()) continue;
                TSource TSource = null;
                return TSource;
            } while ((key = keySelector.apply(value = e.current())) == null);
            if (Float.isNaN(key.floatValue())) {
                TSource TSource = value;
                return TSource;
            }
            while (e.moveNext()) {
                TSource curValue = e.current();
                Float curKey = keySelector.apply(curValue);
                if (curKey == null) continue;
                if (curKey.floatValue() < key.floatValue()) {
                    value = curValue;
                    key = curKey;
                    continue;
                }
                if (!Float.isNaN(curKey.floatValue())) continue;
                TSource TSource = curValue;
                return TSource;
            }
        }
        return value;
    }

    public static <TSource> TSource minByDouble(IEnumerable<TSource> source, DoubleFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            double key;
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            if (Double.isNaN(key = keySelector.apply(value = e.current()))) {
                TSource TSource = value;
                return TSource;
            }
            while (e.moveNext()) {
                TSource curValue = e.current();
                double curKey = keySelector.apply(curValue);
                if (curKey < key) {
                    value = curValue;
                    key = curKey;
                    continue;
                }
                if (!Double.isNaN(curKey)) continue;
                TSource TSource = curValue;
                return TSource;
            }
        }
        return value;
    }

    public static <TSource> TSource minByDoubleNull(IEnumerable<TSource> source, NullableDoubleFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            Double key;
            do {
                if (e.moveNext()) continue;
                TSource TSource = null;
                return TSource;
            } while ((key = keySelector.apply(value = e.current())) == null);
            if (Double.isNaN(key)) {
                TSource TSource = value;
                return TSource;
            }
            while (e.moveNext()) {
                TSource curValue = e.current();
                Double curKey = keySelector.apply(curValue);
                if (curKey == null) continue;
                if (curKey < key) {
                    value = curValue;
                    key = curKey;
                    continue;
                }
                if (!Double.isNaN(curKey)) continue;
                TSource TSource = curValue;
                return TSource;
            }
        }
        return value;
    }

    public static <TSource> TSource minByDecimal(IEnumerable<TSource> source, DecimalFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            BigDecimal key;
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            if ((key = keySelector.apply(value = e.current())) == null) {
                ThrowHelper.throwNullPointerException();
            }
            while (e.moveNext()) {
                TSource curValue = e.current();
                BigDecimal curKey = keySelector.apply(curValue);
                if (curKey.compareTo(key) >= 0) continue;
                value = curValue;
                key = curKey;
            }
        }
        return value;
    }

    public static <TSource> TSource minByDecimalNull(IEnumerable<TSource> source, NullableDecimalFunc1<TSource> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            BigDecimal key;
            do {
                if (e.moveNext()) continue;
                TSource TSource = null;
                return TSource;
            } while ((key = keySelector.apply(value = e.current())) == null);
            while (e.moveNext()) {
                TSource curValue = e.current();
                BigDecimal curKey = keySelector.apply(curValue);
                if (curKey == null || curKey.compareTo(key) >= 0) continue;
                value = curValue;
                key = curKey;
            }
        }
        return value;
    }

    public static <TSource, TKey> TSource minBy(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        Comparator<TKey> comparer = Comparer.Default();
        try (IEnumerator<TSource> e = source.enumerator();){
            TKey key;
            if (!e.moveNext()) {
                ThrowHelper.throwNoElementsException();
            }
            if ((key = keySelector.apply(value = e.current())) == null) {
                ThrowHelper.throwNullPointerException();
            }
            while (e.moveNext()) {
                TSource curValue = e.current();
                TKey curKey = keySelector.apply(curValue);
                if (curKey == null) {
                    ThrowHelper.throwNullPointerException();
                }
                if (comparer.compare(curKey, key) >= 0) continue;
                value = curValue;
                key = curKey;
            }
        }
        return value;
    }

    public static <TSource, TKey> TSource minByNull(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector) {
        TSource value;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        Comparator<TKey> comparer = Comparer.Default();
        try (IEnumerator<TSource> e = source.enumerator();){
            TKey key;
            do {
                if (e.moveNext()) continue;
                TSource TSource = null;
                return TSource;
            } while ((key = keySelector.apply(value = e.current())) == null);
            while (e.moveNext()) {
                TSource curValue = e.current();
                TKey curKey = keySelector.apply(curValue);
                if (curKey == null || comparer.compare(curKey, key) >= 0) continue;
                value = curValue;
                key = curKey;
            }
        }
        return value;
    }
}

