/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractOrderedEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.out;
import java.util.List;

final class OrderedPartition<TElement>
implements IPartition<TElement> {
    private final AbstractOrderedEnumerable<TElement> source;
    private final int minIndexInclusive;
    private final int maxIndexInclusive;

    OrderedPartition(AbstractOrderedEnumerable<TElement> source, int minIdxInclusive, int maxIdxInclusive) {
        this.source = source;
        this.minIndexInclusive = minIdxInclusive;
        this.maxIndexInclusive = maxIdxInclusive;
    }

    @Override
    public IEnumerator<TElement> enumerator() {
        return this.source.enumerator(this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TElement> _skip(int count) {
        int minIndex = this.minIndexInclusive + count;
        return Integer.compareUnsigned(minIndex, this.maxIndexInclusive) > 0 ? EmptyPartition.instance() : new OrderedPartition<TElement>(this.source, minIndex, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TElement> _take(int count) {
        int maxIndex = this.minIndexInclusive + count - 1;
        if (Integer.compareUnsigned(maxIndex, this.maxIndexInclusive) >= 0) {
            return this;
        }
        return new OrderedPartition<TElement>(this.source, this.minIndexInclusive, maxIndex);
    }

    @Override
    public TElement _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.maxIndexInclusive - this.minIndexInclusive) <= 0) {
            return this.source._tryGetElementAt(index + this.minIndexInclusive, found);
        }
        found.value = false;
        return null;
    }

    @Override
    public TElement _tryGetFirst(out<Boolean> found) {
        return this.source._tryGetElementAt(this.minIndexInclusive, found);
    }

    @Override
    public TElement _tryGetLast(out<Boolean> found) {
        return this.source._tryGetLast(this.minIndexInclusive, this.maxIndexInclusive, found);
    }

    @Override
    public TElement[] _toArray(Class<TElement> clazz) {
        return this.source._toArray(clazz, this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public Object[] _toArray() {
        return this.source._toArray(this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public List<TElement> _toList() {
        return this.source._toList(this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        return this.source._getCount(this.minIndexInclusive, this.maxIndexInclusive, onlyIfCheap);
    }
}

