/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.collections.generic.IList;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.RunOnceArrayList;
import com.bestvike.linq.enumerable.RunOnceEnumerable;
import com.bestvike.linq.enumerable.RunOnceLinkedList;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class RunOnce {
    private RunOnce() {
    }

    public static <TSource> IEnumerable<TSource> runOnce(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IList) {
            return source instanceof IArrayList ? new RunOnceArrayList((IArrayList)source) : new RunOnceLinkedList((IList)source);
        }
        return new RunOnceEnumerable<TSource>(source);
    }
}

