/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.exception.ThrowHelper;

final class RunOnceEnumerable<TSource>
implements IEnumerable<TSource> {
    private final IEnumerable<TSource> source;
    private boolean called;

    RunOnceEnumerable(IEnumerable<TSource> source) {
        this.source = source;
    }

    @Override
    public IEnumerator<TSource> enumerator() {
        if (this.called) {
            ThrowHelper.throwRepeatInvokeException();
        }
        this.called = true;
        return this.source.enumerator();
    }
}

