/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IList;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SelectIListPartitionIterator;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.Utilities;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

@DebuggerDisplay(value="Count = {countForDebugger()}")
final class SelectIListIterator<TSource, TResult>
extends Iterator<TResult>
implements IPartition<TResult> {
    private final IList<TSource> source;
    private final Func1<TSource, TResult> selector;
    private IEnumerator<TSource> enumerator;

    SelectIListIterator(IList<TSource> source, Func1<TSource, TResult> selector) {
        assert (source != null);
        assert (selector != null);
        this.source = source;
        this.selector = selector;
    }

    private int countForDebugger() {
        return this.source._getCount();
    }

    @Override
    public Iterator<TResult> clone() {
        return new SelectIListIterator<TSource, TResult>(this.source, this.selector);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                if (this.enumerator.moveNext()) {
                    this.current = this.selector.apply(this.enumerator.current());
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new SelectIListIterator<TSource, TResult2>(this.source, Utilities.combineSelectors(this.selector, selector));
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        int count = this.source._getCount();
        if (count == 0) {
            return ArrayUtils.empty(clazz);
        }
        TResult[] results = ArrayUtils.newInstance(clazz, count);
        int i = 0;
        try (IEnumerator e = this.source.enumerator();){
            while (e.moveNext()) {
                results[i++] = this.selector.apply(e.current());
            }
        }
        return results;
    }

    @Override
    public Object[] _toArray() {
        int count = this.source._getCount();
        if (count == 0) {
            return ArrayUtils.empty();
        }
        Object[] results = new Object[count];
        int i = 0;
        try (IEnumerator e = this.source.enumerator();){
            while (e.moveNext()) {
                results[i++] = this.selector.apply(e.current());
            }
        }
        return results;
    }

    @Override
    public List<TResult> _toList() {
        ArrayList<TResult> results = new ArrayList<TResult>(this.source._getCount());
        try (IEnumerator e = this.source.enumerator();){
            while (e.moveNext()) {
                results.add(this.selector.apply(e.current()));
            }
        }
        return results;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        int count = this.source._getCount();
        if (!onlyIfCheap) {
            try (IEnumerator e = this.source.enumerator();){
                while (e.moveNext()) {
                    this.selector.apply(e.current());
                }
            }
        }
        return count;
    }

    @Override
    public IPartition<TResult> _skip(int count) {
        assert (count > 0);
        return new SelectIListPartitionIterator<TSource, TResult>(this.source, this.selector, count, Integer.MAX_VALUE);
    }

    @Override
    public IPartition<TResult> _take(int count) {
        assert (count > 0);
        return new SelectIListPartitionIterator<TSource, TResult>(this.source, this.selector, 0, count - 1);
    }

    @Override
    public TResult _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.source._getCount()) < 0) {
            found.value = true;
            return this.selector.apply(this.source.get(index));
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetFirst(out<Boolean> found) {
        if (this.source._getCount() != 0) {
            found.value = true;
            return this.selector.apply(this.source.get(0));
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetLast(out<Boolean> found) {
        int len = this.source._getCount();
        if (len != 0) {
            found.value = true;
            return this.selector.apply(this.source.get(len - 1));
        }
        found.value = false;
        return null;
    }
}

