/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.Utilities;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.List;

@DebuggerDisplay(value="Count = {_getCount()}")
final class SelectListPartitionIterator<TSource, TResult>
extends Iterator<TResult>
implements IPartition<TResult> {
    private final IArrayList<TSource> source;
    private final Func1<TSource, TResult> selector;
    private final int minIndexInclusive;
    private final int maxIndexInclusive;

    SelectListPartitionIterator(IArrayList<TSource> source, Func1<TSource, TResult> selector, int minIndexInclusive, int maxIndexInclusive) {
        assert (source != null);
        assert (selector != null);
        assert (minIndexInclusive >= 0);
        assert (minIndexInclusive <= maxIndexInclusive);
        this.source = source;
        this.selector = selector;
        this.minIndexInclusive = minIndexInclusive;
        this.maxIndexInclusive = maxIndexInclusive;
    }

    @Override
    public Iterator<TResult> clone() {
        return new SelectListPartitionIterator<TSource, TResult>(this.source, this.selector, this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public boolean moveNext() {
        int index = this.state - 1;
        if (Integer.compareUnsigned(index, this.maxIndexInclusive - this.minIndexInclusive) <= 0 && index < this.source._getCount() - this.minIndexInclusive) {
            this.current = this.selector.apply(this.source.get(this.minIndexInclusive + index));
            ++this.state;
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new SelectListPartitionIterator<TSource, TResult2>(this.source, Utilities.combineSelectors(this.selector, selector), this.minIndexInclusive, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TResult> _skip(int count) {
        assert (count > 0);
        int minIndex = this.minIndexInclusive + count;
        return Integer.compareUnsigned(minIndex, this.maxIndexInclusive) > 0 ? EmptyPartition.instance() : new SelectListPartitionIterator<TSource, TResult>(this.source, this.selector, minIndex, this.maxIndexInclusive);
    }

    @Override
    public IPartition<TResult> _take(int count) {
        assert (count > 0);
        int maxIndex = this.minIndexInclusive + count - 1;
        return Integer.compareUnsigned(maxIndex, this.maxIndexInclusive) >= 0 ? this : new SelectListPartitionIterator<TSource, TResult>(this.source, this.selector, this.minIndexInclusive, maxIndex);
    }

    @Override
    public TResult _tryGetElementAt(int index, out<Boolean> found) {
        if (Integer.compareUnsigned(index, this.maxIndexInclusive - this.minIndexInclusive) <= 0 && index < this.source._getCount() - this.minIndexInclusive) {
            found.value = true;
            return this.selector.apply(this.source.get(this.minIndexInclusive + index));
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetFirst(out<Boolean> found) {
        if (this.source._getCount() > this.minIndexInclusive) {
            found.value = true;
            return this.selector.apply(this.source.get(this.minIndexInclusive));
        }
        found.value = false;
        return null;
    }

    @Override
    public TResult _tryGetLast(out<Boolean> found) {
        int lastIndex = this.source._getCount() - 1;
        if (lastIndex >= this.minIndexInclusive) {
            found.value = true;
            return this.selector.apply(this.source.get(Math.min(lastIndex, this.maxIndexInclusive)));
        }
        found.value = false;
        return null;
    }

    private int _getCount() {
        int count = this.source._getCount();
        if (count <= this.minIndexInclusive) {
            return 0;
        }
        return Math.min(count - 1, this.maxIndexInclusive) - this.minIndexInclusive + 1;
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        int count = this._getCount();
        if (count == 0) {
            return ArrayUtils.empty(clazz);
        }
        TResult[] array = ArrayUtils.newInstance(clazz, count);
        int i = 0;
        int curIdx = this.minIndexInclusive;
        while (i != array.length) {
            array[i] = this.selector.apply(this.source.get(curIdx));
            ++i;
            ++curIdx;
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        int count = this._getCount();
        if (count == 0) {
            return ArrayUtils.empty();
        }
        Object[] array = new Object[count];
        int i = 0;
        int curIdx = this.minIndexInclusive;
        while (i != array.length) {
            array[i] = this.selector.apply(this.source.get(curIdx));
            ++i;
            ++curIdx;
        }
        return array;
    }

    @Override
    public List<TResult> _toList() {
        int count = this._getCount();
        if (count == 0) {
            return new ArrayList();
        }
        ArrayList<TResult> list = new ArrayList<TResult>(count);
        int end = this.minIndexInclusive + count;
        for (int i = this.minIndexInclusive; i != end; ++i) {
            list.add(this.selector.apply(this.source.get(i)));
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        int count = this._getCount();
        if (!onlyIfCheap) {
            int end = this.minIndexInclusive + count;
            for (int i = this.minIndexInclusive; i != end; ++i) {
                this.selector.apply(this.source.get(i));
            }
        }
        return count;
    }
}

