/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.IndexFunc2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.ArrayBuilder;
import com.bestvike.linq.enumerable.EnumerableHelpers;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.Marker;
import com.bestvike.linq.enumerable.SparseArrayBuilder;
import com.bestvike.linq.util.ListUtils;
import java.util.ArrayList;
import java.util.List;

final class SelectManyIterator2<TSource, TResult>
extends Iterator<TResult>
implements IIListProvider<TResult> {
    private final IEnumerable<TSource> source;
    private final IndexFunc2<TSource, IEnumerable<TResult>> selector;
    private IEnumerator<TSource> enumerator;
    private IEnumerator<TResult> subEnumerator;
    private int index;

    SelectManyIterator2(IEnumerable<TSource> source, IndexFunc2<TSource, IEnumerable<TResult>> selector) {
        assert (source != null);
        assert (selector != null);
        this.source = source;
        this.selector = selector;
    }

    @Override
    public Iterator<TResult> clone() {
        return new SelectManyIterator2<TSource, TResult>(this.source, this.selector);
    }

    @Override
    public boolean moveNext() {
        block5: while (true) {
            switch (this.state) {
                case 1: {
                    this.index = -1;
                    this.enumerator = this.source.enumerator();
                    this.state = 2;
                }
                case 2: {
                    if (this.enumerator.moveNext()) {
                        TSource item = this.enumerator.current();
                        this.index = Math.addExact(this.index, 1);
                        this.subEnumerator = this.selector.apply(item, this.index).enumerator();
                        this.state = 3;
                        continue block5;
                    }
                    this.close();
                    return false;
                }
                case 3: {
                    if (this.subEnumerator.moveNext()) {
                        this.current = this.subEnumerator.current();
                        return true;
                    }
                    this.subEnumerator.close();
                    this.subEnumerator = null;
                    this.state = 2;
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        if (this.subEnumerator != null) {
            this.subEnumerator.close();
            this.subEnumerator = null;
        }
        super.close();
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        SparseArrayBuilder<TResult> builder = new SparseArrayBuilder<TResult>();
        ArrayBuilder<IEnumerable<TResult>> deferredCopies = new ArrayBuilder<IEnumerable<TResult>>();
        int index = 0;
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                IEnumerable<TResult> enumerable = this.selector.apply(e.current(), index);
                index = Math.addExact(index, 1);
                if (!builder.reserveOrAdd(enumerable)) continue;
                deferredCopies.add(enumerable);
            }
        }
        Object[] array = builder.toArray(clazz);
        ArrayBuilder<Marker> markers = builder.getMarkers();
        for (int i = 0; i < markers.getCount(); ++i) {
            Marker marker = markers.get(i);
            IEnumerable enumerable = (IEnumerable)deferredCopies.get(i);
            EnumerableHelpers.copy(enumerable, array, marker.getIndex(), marker.getCount());
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        SparseArrayBuilder<TResult> builder = new SparseArrayBuilder<TResult>();
        ArrayBuilder<IEnumerable<TResult>> deferredCopies = new ArrayBuilder<IEnumerable<TResult>>();
        int index = 0;
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                IEnumerable<TResult> enumerable = this.selector.apply(e.current(), index);
                index = Math.addExact(index, 1);
                if (!builder.reserveOrAdd(enumerable)) continue;
                deferredCopies.add(enumerable);
            }
        }
        Object[] array = builder.toArray();
        ArrayBuilder<Marker> markers = builder.getMarkers();
        for (int i = 0; i < markers.getCount(); ++i) {
            Marker marker = markers.get(i);
            IEnumerable enumerable = (IEnumerable)deferredCopies.get(i);
            EnumerableHelpers.copy(enumerable, array, marker.getIndex(), marker.getCount());
        }
        return array;
    }

    @Override
    public List<TResult> _toList() {
        ArrayList list = new ArrayList();
        int index = 0;
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                ListUtils.addRange(list, this.selector.apply(e.current(), index));
                index = Math.addExact(index, 1);
            }
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            return -1;
        }
        int count = 0;
        int index = 0;
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                count = Math.addExact(count, this.selector.apply(e.current(), index).count());
                index = Math.addExact(index, 1);
            }
        }
        return count;
    }
}

