/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func2;
import com.bestvike.function.IndexFunc2;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;

final class SelectManyResultIterator2<TSource, TCollection, TResult>
extends AbstractIterator<TResult> {
    private final IEnumerable<TSource> source;
    private final IndexFunc2<TSource, IEnumerable<TCollection>> collectionSelector;
    private final Func2<TSource, TCollection, TResult> resultSelector;
    private IEnumerator<TSource> enumerator;
    private IEnumerator<TCollection> subEnumerator;
    private TSource element;
    private int index;

    SelectManyResultIterator2(IEnumerable<TSource> source, IndexFunc2<TSource, IEnumerable<TCollection>> collectionSelector, Func2<TSource, TCollection, TResult> resultSelector) {
        assert (source != null);
        assert (collectionSelector != null);
        assert (resultSelector != null);
        this.source = source;
        this.collectionSelector = collectionSelector;
        this.resultSelector = resultSelector;
    }

    @Override
    public AbstractIterator<TResult> clone() {
        return new SelectManyResultIterator2<TSource, TCollection, TResult>(this.source, this.collectionSelector, this.resultSelector);
    }

    @Override
    public boolean moveNext() {
        block5: while (true) {
            switch (this.state) {
                case 1: {
                    this.index = -1;
                    this.enumerator = this.source.enumerator();
                    this.state = 2;
                }
                case 2: {
                    if (this.enumerator.moveNext()) {
                        this.element = this.enumerator.current();
                        this.index = Math.addExact(this.index, 1);
                        this.subEnumerator = this.collectionSelector.apply(this.element, this.index).enumerator();
                        this.state = 3;
                        continue block5;
                    }
                    this.close();
                    return false;
                }
                case 3: {
                    if (this.subEnumerator.moveNext()) {
                        TCollection item = this.subEnumerator.current();
                        this.current = this.resultSelector.apply(this.element, item);
                        return true;
                    }
                    this.subEnumerator.close();
                    this.subEnumerator = null;
                    this.state = 2;
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
            this.element = null;
        }
        if (this.subEnumerator != null) {
            this.subEnumerator.close();
            this.subEnumerator = null;
        }
        super.close();
    }
}

