/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.ShuffledEnumerable;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Shuffle {
    private Shuffle() {
    }

    public static <TSource> IEnumerable<TSource> shuffle(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new ShuffledEnumerable<TSource>(source);
    }

    public static <TSource> IEnumerable<TSource> shuffle(IEnumerable<TSource> source, long seed) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        return new ShuffledEnumerable<TSource>(source, seed);
    }
}

