/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Array;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import java.util.Random;

final class ShuffledEnumerable<TSource>
implements IEnumerable<TSource> {
    private final IEnumerable<TSource> source;
    private final Long seed;

    ShuffledEnumerable(IEnumerable<TSource> source) {
        this.source = source;
        this.seed = null;
    }

    ShuffledEnumerable(IEnumerable<TSource> source, long seed) {
        this.source = source;
        this.seed = seed;
    }

    @Override
    public IEnumerator<TSource> enumerator() {
        Random rnd = this.seed == null ? new Random() : new Random(this.seed);
        Array<TSource> array = this.source.toArray();
        int count = array._getCount();
        for (int i = count - 1; i > 0; --i) {
            int j = rnd.nextInt(i + 1);
            if (i == j) continue;
            TSource swapped = array.get(i);
            array.set(i, array.get(j));
            array.set(j, swapped);
        }
        return array.enumerator();
    }
}

