/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IList;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Single {
    private Single() {
    }

    public static <TSource> TSource single(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IList) {
            IList list = (IList)source;
            switch (list._getCount()) {
                case 0: {
                    ThrowHelper.throwNoElementsException();
                    return null;
                }
                case 1: {
                    return (TSource)list.get(0);
                }
            }
        } else {
            try (IEnumerator<TSource> e = source.enumerator();){
                if (!e.moveNext()) {
                    ThrowHelper.throwNoElementsException();
                }
                TSource result = e.current();
                if (!e.moveNext()) {
                    TSource TSource = result;
                    return TSource;
                }
            }
        }
        ThrowHelper.throwMoreThanOneElementException();
        return null;
    }

    public static <TSource> TSource single(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                TSource result = e.current();
                if (!predicate.apply(result)) continue;
                while (e.moveNext()) {
                    if (!predicate.apply(e.current())) continue;
                    ThrowHelper.throwMoreThanOneMatchException();
                }
                TSource TSource = result;
                return TSource;
            }
        }
        ThrowHelper.throwNoMatchException();
        return null;
    }

    public static <TSource> TSource singleOrDefault(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IList) {
            IList list = (IList)source;
            switch (list._getCount()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (TSource)list.get(0);
                }
            }
        } else {
            try (IEnumerator<TSource> e = source.enumerator();){
                if (!e.moveNext()) {
                    TSource TSource = null;
                    return TSource;
                }
                TSource result = e.current();
                if (!e.moveNext()) {
                    TSource TSource = result;
                    return TSource;
                }
            }
        }
        ThrowHelper.throwMoreThanOneElementException();
        return null;
    }

    public static <TSource> TSource singleOrDefault(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                TSource result = e.current();
                if (!predicate.apply(result)) continue;
                while (e.moveNext()) {
                    if (!predicate.apply(e.current())) continue;
                    ThrowHelper.throwMoreThanOneMatchException();
                }
                TSource TSource = result;
                return TSource;
            }
        }
        return null;
    }
}

