/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.collections.generic.IList;
import com.bestvike.function.IndexPredicate2;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.EnumerablePartition;
import com.bestvike.linq.enumerable.IListPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.ListPartition;
import com.bestvike.linq.enumerable.SkipLastIterator;
import com.bestvike.linq.enumerable.SkipWhileIterator;
import com.bestvike.linq.enumerable.SkipWhileIterator2;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Skip {
    private Skip() {
    }

    public static <TSource> IEnumerable<TSource> skip(IEnumerable<TSource> source, int count) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (count <= 0) {
            if (source instanceof Iterator || source instanceof IPartition) {
                return source;
            }
            count = 0;
        } else if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            return partition._skip(count);
        }
        if (source instanceof IList) {
            if (source instanceof IArrayList) {
                IArrayList sourceList = (IArrayList)source;
                return new ListPartition(sourceList, count, Integer.MAX_VALUE);
            }
            IList sourceList = (IList)source;
            return new IListPartition(sourceList, count, Integer.MAX_VALUE);
        }
        return new EnumerablePartition<TSource>(source, count, -1);
    }

    public static <TSource> IEnumerable<TSource> skipWhile(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        return new SkipWhileIterator<TSource>(source, predicate);
    }

    public static <TSource> IEnumerable<TSource> skipWhile(IEnumerable<TSource> source, IndexPredicate2<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        return new SkipWhileIterator2<TSource>(source, predicate);
    }

    public static <TSource> IEnumerable<TSource> skipLast(IEnumerable<TSource> source, int count) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (count <= 0) {
            return source.skip(0);
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            int length = partition._getCount(true);
            if (length >= 0) {
                return length - count > 0 ? partition.take(length - count) : EmptyPartition.instance();
            }
        } else if (source instanceof IList) {
            if (source instanceof IArrayList) {
                IArrayList sourceList = (IArrayList)source;
                int sourceCount = sourceList._getCount();
                return sourceCount > count ? new ListPartition(sourceList, 0, sourceCount - count - 1) : EmptyPartition.instance();
            }
            IList sourceList = (IList)source;
            int sourceCount = sourceList._getCount();
            return sourceCount > count ? new IListPartition(sourceList, 0, sourceCount - count - 1) : EmptyPartition.instance();
        }
        return new SkipLastIterator<TSource>(source, count);
    }
}

