/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Queue;

final class SkipLastIterator<TSource>
extends AbstractIterator<TSource> {
    private final IEnumerable<TSource> source;
    private final int count;
    private IEnumerator<TSource> enumerator;
    private Queue<TSource> queue;

    SkipLastIterator(IEnumerable<TSource> source, int count) {
        assert (source != null);
        assert (count > 0);
        this.source = source;
        this.count = count;
    }

    @Override
    public AbstractIterator<TSource> clone() {
        return new SkipLastIterator<TSource>(this.source, this.count);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.queue = new ArrayDeque<TSource>();
                this.enumerator = this.source.enumerator();
                while (this.enumerator.moveNext()) {
                    if (this.queue.size() == this.count) {
                        this.current = this.queue.remove();
                        this.state = 2;
                        return true;
                    }
                    this.queue.add(this.enumerator.current());
                }
                this.close();
                return false;
            }
            case 2: {
                this.queue.add(this.enumerator.current());
                if (this.enumerator.moveNext()) {
                    this.current = this.queue.remove();
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
            this.queue = null;
        }
        super.close();
    }
}

