/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.ArrayBuilder;
import com.bestvike.linq.enumerable.CopyPosition;
import com.bestvike.linq.enumerable.EnumerableHelpers;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.enumerable.Marker;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.out;

final class SparseArrayBuilder<T> {
    private final LargeArrayBuilder<T> builder = new LargeArrayBuilder();
    private final ArrayBuilder<Marker> markers = new ArrayBuilder();
    private int reservedCount;

    SparseArrayBuilder() {
    }

    public int getCount() {
        return Math.addExact(this.builder.getCount(), this.reservedCount);
    }

    public ArrayBuilder<Marker> getMarkers() {
        return this.markers;
    }

    public void add(T item) {
        this.builder.add(item);
    }

    public void addRange(IEnumerable<T> items) {
        this.builder.addRange(items);
    }

    public void copyTo(Object[] array, int arrayIndex, int count) {
        assert (array != null);
        assert (arrayIndex >= 0);
        assert (count >= 0 && count <= this.getCount());
        assert (array.length - arrayIndex >= count);
        int copied = 0;
        CopyPosition position = CopyPosition.start();
        for (int i = 0; i < this.markers.getCount(); ++i) {
            Marker marker = this.markers.get(i);
            int toCopy = Math.min(marker.getIndex() - copied, count);
            if (toCopy > 0) {
                position = this.builder.copyTo(position, array, arrayIndex, toCopy);
                arrayIndex += toCopy;
                copied += toCopy;
                count -= toCopy;
            }
            if (count == 0) {
                return;
            }
            int reservedCount = Math.min(marker.getCount(), count);
            arrayIndex += reservedCount;
            copied += reservedCount;
            count -= reservedCount;
        }
        if (count > 0) {
            this.builder.copyTo(position, array, arrayIndex, count);
        }
    }

    public void reserve(int count) {
        assert (count >= 0);
        this.markers.add(new Marker(count, this.getCount()));
        this.reservedCount = Math.addExact(this.reservedCount, count);
    }

    public boolean reserveOrAdd(IEnumerable<T> items) {
        out<Integer> itemCountRef = out.init();
        if (EnumerableHelpers.tryGetCount(items, itemCountRef)) {
            int itemCount = (Integer)itemCountRef.value;
            if (itemCount > 0) {
                this.reserve(itemCount);
                return true;
            }
        } else {
            this.addRange(items);
        }
        return false;
    }

    public T[] toArray(Class<T> clazz) {
        if (this.markers.getCount() == 0) {
            assert (this.reservedCount == 0);
            return this.builder.toArray(clazz);
        }
        Object[] array = ArrayUtils.newInstance(clazz, this.getCount());
        this.copyTo(array, 0, array.length);
        return array;
    }

    public Object[] toArray() {
        if (this.markers.getCount() == 0) {
            assert (this.reservedCount == 0);
            return this.builder.toArray();
        }
        Object[] array = new Object[this.getCount()];
        this.copyTo(array, 0, array.length);
        return array;
    }
}

