/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Array;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.adapter.enumerable.SingletonEnumerable;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIterator0;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIterator1;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIterator2;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIterator3;
import com.bestvike.linq.enumerable.CharKeepEmptySplitIteratorN;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIterator0;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIterator1;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIterator2;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIterator3;
import com.bestvike.linq.enumerable.CharOmitEmptySplitIteratorN;
import com.bestvike.linq.enumerable.StringKeepEmptySplitIterator1;
import com.bestvike.linq.enumerable.StringKeepEmptySplitIteratorN;
import com.bestvike.linq.enumerable.StringOmitEmptySplitIterator1;
import com.bestvike.linq.enumerable.StringOmitEmptySplitIteratorN;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.linq.util.StringSplitOptions;
import com.bestvike.linq.util.Strings;

public final class Split {
    private Split() {
    }

    public static IEnumerable<String> split(CharSequence source, char separator) {
        return Split.split(source, separator, StringSplitOptions.None);
    }

    public static IEnumerable<String> split(CharSequence source, char separator, StringSplitOptions options) {
        boolean omitEmptyEntries;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (options == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.options);
        }
        boolean bl = omitEmptyEntries = options == StringSplitOptions.RemoveEmptyEntries;
        if (omitEmptyEntries && source.length() == 0) {
            return Array.empty();
        }
        return omitEmptyEntries ? new CharOmitEmptySplitIterator1(source, separator) : new CharKeepEmptySplitIterator1(source, separator);
    }

    public static IEnumerable<String> split(CharSequence source, char[] separator) {
        return Split.split(source, separator, StringSplitOptions.None);
    }

    public static IEnumerable<String> split(CharSequence source, char[] separator, StringSplitOptions options) {
        boolean omitEmptyEntries;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (options == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.options);
        }
        boolean bl = omitEmptyEntries = options == StringSplitOptions.RemoveEmptyEntries;
        if (omitEmptyEntries && source.length() == 0) {
            return Array.empty();
        }
        switch (separator == null ? 0 : separator.length) {
            case 0: {
                return omitEmptyEntries ? new CharOmitEmptySplitIterator0(source) : new CharKeepEmptySplitIterator0(source);
            }
            case 1: {
                return omitEmptyEntries ? new CharOmitEmptySplitIterator1(source, separator[0]) : new CharKeepEmptySplitIterator1(source, separator[0]);
            }
            case 2: {
                return omitEmptyEntries ? new CharOmitEmptySplitIterator2(source, separator[0], separator[1]) : new CharKeepEmptySplitIterator2(source, separator[0], separator[1]);
            }
            case 3: {
                return omitEmptyEntries ? new CharOmitEmptySplitIterator3(source, separator[0], separator[1], separator[2]) : new CharKeepEmptySplitIterator3(source, separator[0], separator[1], separator[2]);
            }
        }
        return omitEmptyEntries ? new CharOmitEmptySplitIteratorN(source, separator) : new CharKeepEmptySplitIteratorN(source, separator);
    }

    public static IEnumerable<String> split(CharSequence source, CharSequence separator) {
        return Split.split(source, separator, StringSplitOptions.None);
    }

    public static IEnumerable<String> split(CharSequence source, CharSequence separator, StringSplitOptions options) {
        boolean omitEmptyEntries;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (options == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.options);
        }
        boolean bl = omitEmptyEntries = options == StringSplitOptions.RemoveEmptyEntries;
        if (omitEmptyEntries && source.length() == 0) {
            return Array.empty();
        }
        if (Strings.isNullOrEmpty(separator)) {
            return new SingletonEnumerable<String>(source.toString());
        }
        return omitEmptyEntries ? new StringOmitEmptySplitIterator1(source, separator) : new StringKeepEmptySplitIterator1(source, separator);
    }

    public static IEnumerable<String> split(CharSequence source, CharSequence[] separator) {
        return Split.split(source, separator, StringSplitOptions.None);
    }

    public static IEnumerable<String> split(CharSequence source, CharSequence[] separator, StringSplitOptions options) {
        boolean omitEmptyEntries;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (options == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.options);
        }
        boolean bl = omitEmptyEntries = options == StringSplitOptions.RemoveEmptyEntries;
        if (omitEmptyEntries && source.length() == 0) {
            return Array.empty();
        }
        if (separator == null || separator.length == 0) {
            return omitEmptyEntries ? new CharOmitEmptySplitIterator0(source) : new CharKeepEmptySplitIterator0(source);
        }
        return omitEmptyEntries ? new StringOmitEmptySplitIteratorN(source, separator) : new StringKeepEmptySplitIteratorN(source, separator);
    }
}

