/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.SplitInternal;
import com.bestvike.linq.util.Strings;

final class StringKeepEmptySplitIterator1
extends AbstractIterator<String> {
    private final CharSequence source;
    private final CharSequence separator;

    StringKeepEmptySplitIterator1(CharSequence source, CharSequence separator) {
        assert (source != null);
        assert (!Strings.isNullOrEmpty(separator));
        this.source = source;
        this.separator = separator;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new StringKeepEmptySplitIterator1(this.source, this.separator);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        if (index < 0) {
            this.close();
            return false;
        }
        int length = this.source.length();
        char firstSepChar = this.separator.charAt(0);
        int currentSepLength = this.separator.length();
        int beginIndex = index;
        while (index < length) {
            char current = this.source.charAt(index);
            if (current == firstSepChar && currentSepLength <= length - index && (currentSepLength == 1 || SplitInternal.sequenceEqual(this.source, index + 1, this.separator, 1, currentSepLength - 1))) {
                this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
                this.state = index + currentSepLength + 1;
                return true;
            }
            ++index;
        }
        if (index == length) {
            this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
            this.state = index + 2;
            return true;
        }
        this.close();
        return false;
    }
}

