/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.SplitInternal;
import com.bestvike.linq.util.Strings;

final class StringKeepEmptySplitIteratorN
extends AbstractIterator<String> {
    private final CharSequence source;
    private final CharSequence[] separators;

    StringKeepEmptySplitIteratorN(CharSequence source, CharSequence[] separators) {
        assert (source != null);
        assert (separators != null && separators.length > 0);
        this.source = source;
        this.separators = separators;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new StringKeepEmptySplitIteratorN(this.source, this.separators);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        if (index < 0) {
            this.close();
            return false;
        }
        int length = this.source.length();
        int beginIndex = index;
        while (index < length) {
            char current = this.source.charAt(index);
            for (CharSequence separator : this.separators) {
                if (Strings.isNullOrEmpty(separator)) continue;
                int currentSepLength = separator.length();
                if (current != separator.charAt(0) || currentSepLength > length - index || currentSepLength != 1 && !SplitInternal.sequenceEqual(this.source, index + 1, separator, 1, currentSepLength - 1)) continue;
                this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
                this.state = index + currentSepLength + 1;
                return true;
            }
            ++index;
        }
        if (index == length) {
            this.current = index == beginIndex ? "" : this.source.subSequence(beginIndex, index).toString();
            this.state = index + 2;
            return true;
        }
        this.close();
        return false;
    }
}

