/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.SplitInternal;
import com.bestvike.linq.util.Strings;

final class StringOmitEmptySplitIterator1
extends AbstractIterator<String> {
    private final CharSequence source;
    private final CharSequence separator;

    StringOmitEmptySplitIterator1(CharSequence source, CharSequence separator) {
        assert (!Strings.isNullOrEmpty(source));
        assert (!Strings.isNullOrEmpty(separator));
        this.source = source;
        this.separator = separator;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new StringOmitEmptySplitIterator1(this.source, this.separator);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int length = this.source.length();
        char firstSepChar = this.separator.charAt(0);
        int currentSepLength = this.separator.length();
        for (int index = this.state - 1; index < length; index += currentSepLength) {
            char tail;
            char head = this.source.charAt(index);
            if (head == firstSepChar && currentSepLength <= length - index && (currentSepLength == 1 || SplitInternal.sequenceEqual(this.source, index + 1, this.separator, 1, currentSepLength - 1))) {
                continue;
            }
            int beginIndex = index++;
            while (index < length && ((tail = this.source.charAt(index)) != firstSepChar || currentSepLength > length - index || currentSepLength != 1 && !SplitInternal.sequenceEqual(this.source, index + 1, this.separator, 1, currentSepLength - 1))) {
                ++index;
            }
            this.current = this.source.subSequence(beginIndex, index).toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }
}

