/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.SplitInternal;
import com.bestvike.linq.util.Strings;

final class StringOmitEmptySplitIteratorN
extends AbstractIterator<String> {
    private final CharSequence source;
    private final CharSequence[] separators;

    StringOmitEmptySplitIteratorN(CharSequence source, CharSequence[] separators) {
        assert (!Strings.isNullOrEmpty(source));
        assert (separators != null && separators.length > 0);
        this.source = source;
        this.separators = separators;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new StringOmitEmptySplitIteratorN(this.source, this.separators);
    }

    @Override
    public boolean moveNext() {
        int currentSepLength;
        if (this.state == -1) {
            return false;
        }
        int length = this.source.length();
        block0: for (int index = this.state - 1; index < length; index += currentSepLength) {
            char head = this.source.charAt(index);
            for (CharSequence separator : this.separators) {
                if (Strings.isNullOrEmpty(separator)) continue;
                currentSepLength = separator.length();
                if (head != separator.charAt(0) || currentSepLength > length - index || currentSepLength != 1 && !SplitInternal.sequenceEqual(this.source, index + 1, separator, 1, currentSepLength - 1)) continue;
                continue block0;
            }
            int beginIndex = index++;
            block2: while (index < length) {
                char tail = this.source.charAt(index);
                for (CharSequence separator : this.separators) {
                    if (Strings.isNullOrEmpty(separator)) continue;
                    int currentSepLength2 = separator.length();
                    if (tail == separator.charAt(0) && currentSepLength2 <= length - index && (currentSepLength2 == 1 || SplitInternal.sequenceEqual(this.source, index + 1, separator, 1, currentSepLength2 - 1))) break block2;
                }
                ++index;
            }
            this.current = this.source.subSequence(beginIndex, index).toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }
}

