/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.collections.generic.IList;
import com.bestvike.function.IndexPredicate2;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.EnumerablePartition;
import com.bestvike.linq.enumerable.IListPartition;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.ListPartition;
import com.bestvike.linq.enumerable.TakeLastIterator;
import com.bestvike.linq.enumerable.TakeWhileIterator;
import com.bestvike.linq.enumerable.TakeWhileIterator2;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Take {
    private Take() {
    }

    public static <TSource> IEnumerable<TSource> take(IEnumerable<TSource> source, int count) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (count <= 0) {
            return EmptyPartition.instance();
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            return partition._take(count);
        }
        if (source instanceof IList) {
            if (source instanceof IArrayList) {
                IArrayList sourceList = (IArrayList)source;
                return new ListPartition(sourceList, 0, count - 1);
            }
            IList sourceList = (IList)source;
            return new IListPartition(sourceList, 0, count - 1);
        }
        return new EnumerablePartition<TSource>(source, 0, count - 1);
    }

    public static <TSource> IEnumerable<TSource> takeWhile(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        return new TakeWhileIterator<TSource>(source, predicate);
    }

    public static <TSource> IEnumerable<TSource> takeWhile(IEnumerable<TSource> source, IndexPredicate2<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        return new TakeWhileIterator2<TSource>(source, predicate);
    }

    public static <TSource> IEnumerable<TSource> takeLast(IEnumerable<TSource> source, int count) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (count <= 0) {
            return EmptyPartition.instance();
        }
        if (source instanceof IPartition) {
            IPartition partition = (IPartition)source;
            int length = partition._getCount(true);
            if (length >= 0) {
                return length - count > 0 ? partition.skip(length - count) : partition;
            }
        } else if (source instanceof IList) {
            if (source instanceof IArrayList) {
                IArrayList sourceList = (IArrayList)source;
                int sourceCount = sourceList._getCount();
                return sourceCount > count ? new ListPartition(sourceList, sourceCount - count, sourceCount) : new ListPartition(sourceList, 0, sourceCount);
            }
            IList sourceList = (IList)source;
            int sourceCount = sourceList._getCount();
            return sourceCount > count ? new IListPartition(sourceList, sourceCount - count, sourceCount) : new IListPartition(sourceList, 0, sourceCount);
        }
        return new TakeLastIterator<TSource>(source, count);
    }
}

