/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import java.util.ArrayDeque;
import java.util.Queue;

final class TakeLastIterator<TSource>
extends AbstractIterator<TSource> {
    private final IEnumerable<TSource> source;
    private final int count;
    private Queue<TSource> queue;

    TakeLastIterator(IEnumerable<TSource> source, int count) {
        assert (source != null);
        assert (count > 0);
        this.source = source;
        this.count = count;
    }

    @Override
    public AbstractIterator<TSource> clone() {
        return new TakeLastIterator<TSource>(this.source, this.count);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                try (IEnumerator<TSource> e = this.source.enumerator();){
                    if (!e.moveNext()) {
                        this.close();
                        boolean bl = false;
                        return bl;
                    }
                    this.queue = new ArrayDeque<TSource>();
                    this.queue.add(e.current());
                    while (e.moveNext()) {
                        if (this.queue.size() < this.count) {
                            this.queue.add(e.current());
                            continue;
                        }
                        do {
                            this.queue.remove();
                            this.queue.add(e.current());
                        } while (e.moveNext());
                        break;
                    }
                }
                assert (this.queue.size() <= this.count);
                this.current = this.queue.remove();
                this.state = 2;
                return true;
            }
            case 2: {
                if (this.queue.size() > 0) {
                    this.current = this.queue.remove();
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.queue = null;
        super.close();
    }
}

