/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.collections.generic.ICollection;
import com.bestvike.function.Action2;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.EnumerableHelpers;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ToCollection {
    private ToCollection() {
    }

    public static <TSource> TSource[] toArray(IEnumerable<TSource> source, Class<TSource> clazz) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (clazz == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.clazz);
        }
        if (source instanceof IIListProvider) {
            IIListProvider listProvider = (IIListProvider)source;
            return listProvider._toArray(clazz);
        }
        return EnumerableHelpers.toArray(source, clazz);
    }

    public static <TSource> Object[] toArray(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IIListProvider) {
            IIListProvider listProvider = (IIListProvider)source;
            return listProvider._toArray();
        }
        return EnumerableHelpers.toArray(source);
    }

    public static <TSource> List<TSource> toList(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof IIListProvider) {
            IIListProvider listProvider = (IIListProvider)source;
            return listProvider._toList();
        }
        return EnumerableHelpers.toList(source);
    }

    public static <TSource> List<TSource> toLinkedList(IEnumerable<TSource> source) {
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int capacity = collection._getCount();
            if (capacity == 0) {
                return new LinkedList();
            }
            if (collection instanceof IArrayList) {
                IArrayList ilist = (IArrayList)collection;
                LinkedList list = new LinkedList();
                for (int i = 0; i < capacity; ++i) {
                    list.add(ilist.get(i));
                }
                return list;
            }
        }
        LinkedList<TSource> list = new LinkedList<TSource>();
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                list.add(e.current());
            }
        }
        return list;
    }

    public static <TSource, TKey> Map<TKey, TSource> toMap(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int capacity = collection._getCount();
            if (capacity == 0) {
                return new HashMap();
            }
            if (collection instanceof IArrayList) {
                IArrayList list = (IArrayList)collection;
                HashMap map = new HashMap(capacity);
                for (int i = 0; i < capacity; ++i) {
                    Object element = list.get(i);
                    map.put(keySelector.apply(element), element);
                }
                return map;
            }
            HashMap<TKey, TSource> map = new HashMap<TKey, TSource>(capacity);
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    TSource element = e.current();
                    map.put(keySelector.apply(element), element);
                }
            }
            return map;
        }
        HashMap<TKey, TSource> map = new HashMap<TKey, TSource>();
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                TSource element = e.current();
                map.put(keySelector.apply(element), element);
            }
        }
        return map;
    }

    public static <TSource, TKey, TElement> Map<TKey, TElement> toMap(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector, Func1<TSource, TElement> elementSelector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        if (elementSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.elementSelector);
        }
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int capacity = collection._getCount();
            if (capacity == 0) {
                return new HashMap();
            }
            if (collection instanceof IArrayList) {
                IArrayList list = (IArrayList)collection;
                HashMap<TKey, TElement> map = new HashMap<TKey, TElement>(capacity);
                for (int i = 0; i < capacity; ++i) {
                    Object element = list.get(i);
                    map.put(keySelector.apply(element), elementSelector.apply(element));
                }
                return map;
            }
            HashMap<TKey, TElement> map = new HashMap<TKey, TElement>(capacity);
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    TSource element = e.current();
                    map.put(keySelector.apply(element), elementSelector.apply(element));
                }
            }
            return map;
        }
        HashMap<TKey, TElement> map = new HashMap<TKey, TElement>();
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                TSource element = e.current();
                map.put(keySelector.apply(element), elementSelector.apply(element));
            }
        }
        return map;
    }

    public static <TSource, TKey> Map<TKey, TSource> toLinkedMap(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int capacity = collection._getCount();
            if (capacity == 0) {
                return new LinkedHashMap();
            }
            if (collection instanceof IArrayList) {
                IArrayList list = (IArrayList)collection;
                LinkedHashMap map = new LinkedHashMap(capacity);
                for (int i = 0; i < capacity; ++i) {
                    Object element = list.get(i);
                    map.put(keySelector.apply(element), element);
                }
                return map;
            }
            LinkedHashMap<TKey, TSource> map = new LinkedHashMap<TKey, TSource>(capacity);
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    TSource element = e.current();
                    map.put(keySelector.apply(element), element);
                }
            }
            return map;
        }
        LinkedHashMap<TKey, TSource> map = new LinkedHashMap<TKey, TSource>();
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                TSource element = e.current();
                map.put(keySelector.apply(element), element);
            }
        }
        return map;
    }

    public static <TSource, TKey, TElement> Map<TKey, TElement> toLinkedMap(IEnumerable<TSource> source, Func1<TSource, TKey> keySelector, Func1<TSource, TElement> elementSelector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        if (elementSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.elementSelector);
        }
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int capacity = collection._getCount();
            if (capacity == 0) {
                return new LinkedHashMap();
            }
            if (collection instanceof IArrayList) {
                IArrayList list = (IArrayList)collection;
                LinkedHashMap<TKey, TElement> map = new LinkedHashMap<TKey, TElement>(capacity);
                for (int i = 0; i < capacity; ++i) {
                    Object element = list.get(i);
                    map.put(keySelector.apply(element), elementSelector.apply(element));
                }
                return map;
            }
            LinkedHashMap<TKey, TElement> map = new LinkedHashMap<TKey, TElement>(capacity);
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    TSource element = e.current();
                    map.put(keySelector.apply(element), elementSelector.apply(element));
                }
            }
            return map;
        }
        LinkedHashMap<TKey, TElement> map = new LinkedHashMap<TKey, TElement>();
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                TSource element = e.current();
                map.put(keySelector.apply(element), elementSelector.apply(element));
            }
        }
        return map;
    }

    public static <TSource> Set<TSource> toSet(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int capacity = collection._getCount();
            if (capacity == 0) {
                return new HashSet();
            }
            if (collection instanceof IArrayList) {
                IArrayList list = (IArrayList)collection;
                HashSet set = new HashSet(capacity);
                for (int i = 0; i < capacity; ++i) {
                    set.add(list.get(i));
                }
                return set;
            }
            HashSet<TSource> set = new HashSet<TSource>(capacity);
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    set.add(e.current());
                }
            }
            return set;
        }
        HashSet<TSource> set = new HashSet<TSource>();
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                set.add(e.current());
            }
        }
        return set;
    }

    public static <TSource> Set<TSource> toLinkedSet(IEnumerable<TSource> source) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof ICollection) {
            ICollection collection = (ICollection)source;
            int capacity = collection._getCount();
            if (capacity == 0) {
                return new LinkedHashSet();
            }
            if (collection instanceof IArrayList) {
                IArrayList list = (IArrayList)collection;
                LinkedHashSet set = new LinkedHashSet(capacity);
                for (int i = 0; i < capacity; ++i) {
                    set.add(list.get(i));
                }
                return set;
            }
            LinkedHashSet<TSource> set = new LinkedHashSet<TSource>(capacity);
            try (IEnumerator<TSource> e = source.enumerator();){
                while (e.moveNext()) {
                    set.add(e.current());
                }
            }
            return set;
        }
        LinkedHashSet<TSource> set = new LinkedHashSet<TSource>();
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                set.add(e.current());
            }
        }
        return set;
    }

    public static <TSource, TCollection> TCollection toCollection(IEnumerable<TSource> source, TCollection collection, Action2<TCollection, TSource> action) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (collection == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.collection);
        }
        if (action == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.action);
        }
        if (source instanceof IArrayList) {
            IArrayList list = (IArrayList)source;
            int count = list._getCount();
            for (int i = 0; i < count; ++i) {
                action.apply(collection, list.get(i));
            }
            return collection;
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                action.apply(collection, e.current());
            }
        }
        return collection;
    }

    public static <TSource, TCollection, TResult> TResult toCollection(IEnumerable<TSource> source, TCollection collection, Action2<TCollection, TSource> action, Func1<TCollection, TResult> resultSelector) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (collection == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.collection);
        }
        if (action == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.action);
        }
        if (resultSelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.resultSelector);
        }
        if (source instanceof IArrayList) {
            IArrayList list = (IArrayList)source;
            int count = list._getCount();
            for (int i = 0; i < count; ++i) {
                action.apply(collection, list.get(i));
            }
            return resultSelector.apply(collection);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                action.apply(collection, e.current());
            }
        }
        return resultSelector.apply(collection);
    }
}

