/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.UnionIterator;
import com.bestvike.linq.enumerable.UnionIterator2;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.linq.util.Utilities;

public final class Union {
    private Union() {
    }

    public static <TSource> IEnumerable<TSource> union(IEnumerable<TSource> first, IEnumerable<TSource> second) {
        return Union.union(first, second, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <TSource> IEnumerable<TSource> union(IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer) {
        UnionIterator unionIterator;
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        if (first instanceof UnionIterator) {
            UnionIterator union = (UnionIterator)first;
            if (Utilities.areEqualityComparersEqual(comparer, union.comparer)) {
                unionIterator = union._union(second);
                return unionIterator;
            }
        }
        unionIterator = new UnionIterator2<TSource>(first, second, comparer);
        return unionIterator;
    }
}

