/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.UnionByIterator;
import com.bestvike.linq.enumerable.UnionByIterator2;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.linq.util.Utilities;

public final class UnionBy {
    private UnionBy() {
    }

    public static <TSource, TKey> IEnumerable<TSource> unionBy(IEnumerable<TSource> first, IEnumerable<TSource> second, Func1<TSource, TKey> keySelector) {
        return UnionBy.unionBy(first, second, keySelector, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <TSource, TKey> IEnumerable<TSource> unionBy(IEnumerable<TSource> first, IEnumerable<TSource> second, Func1<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer) {
        UnionByIterator unionByIterator;
        if (first == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.first);
        }
        if (second == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.second);
        }
        if (keySelector == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.keySelector);
        }
        if (first instanceof UnionByIterator) {
            UnionByIterator unionBy = (UnionByIterator)first;
            if (keySelector == unionBy.keySelector && Utilities.areEqualityComparersEqual(comparer, unionBy.comparer)) {
                unionByIterator = unionBy._unionBy(second);
                return unionByIterator;
            }
        }
        unionByIterator = new UnionByIterator2<TSource, TKey>(first, second, keySelector, comparer);
        return unionByIterator;
    }
}

