/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.enumerable.Set;
import java.util.ArrayList;
import java.util.List;

abstract class UnionByIterator<TSource, TKey>
extends Iterator<TSource>
implements IIListProvider<TSource> {
    final Func1<TSource, TKey> keySelector;
    final IEqualityComparer<TKey> comparer;
    private IEnumerator<TSource> enumerator;
    private Set<TKey> set;

    UnionByIterator(Func1<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer) {
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
            this.set = null;
        }
        super.close();
    }

    abstract IEnumerable<TSource> getEnumerable(int var1);

    abstract UnionByIterator<TSource, TKey> _unionBy(IEnumerable<TSource> var1);

    private void setEnumerator(IEnumerator<TSource> enumerator) {
        if (this.enumerator != null) {
            this.enumerator.close();
        }
        this.enumerator = enumerator;
    }

    private void storeFirst() {
        Set<TKey> set = new Set<TKey>(this.comparer);
        TSource element = this.enumerator.current();
        set.add(this.keySelector.apply(element));
        this.current = element;
        this.set = set;
    }

    private boolean getNext() {
        Set<TKey> set = this.set;
        assert (set != null);
        while (this.enumerator.moveNext()) {
            TSource element = this.enumerator.current();
            if (!set.add(this.keySelector.apply(element))) continue;
            this.current = element;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveNext() {
        if (this.state == 1) {
            IEnumerable<TSource> enumerable = this.getEnumerable(0);
            while (enumerable != null) {
                IEnumerator<TSource> enumerator = enumerable.enumerator();
                this.setEnumerator(enumerator);
                ++this.state;
                if (enumerator.moveNext()) {
                    this.storeFirst();
                    return true;
                }
                enumerable = this.getEnumerable(this.state - 1);
            }
        } else if (this.state > 0) {
            while (true) {
                if (this.getNext()) {
                    return true;
                }
                IEnumerable<TSource> enumerable = this.getEnumerable(this.state - 1);
                if (enumerable == null) break;
                this.setEnumerator(enumerable.enumerator());
                ++this.state;
            }
        }
        this.close();
        return false;
    }

    private Set<TKey> fillSet() {
        Set<TKey> set = new Set<TKey>(this.comparer);
        int index = 0;
        IEnumerable<TSource> enumerable;
        while ((enumerable = this.getEnumerable(index)) != null) {
            set.unionWith(enumerable, this.keySelector);
            ++index;
        }
        return set;
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        LargeArrayBuilder<TSource> builder = new LargeArrayBuilder<TSource>();
        Set<TKey> set = new Set<TKey>(this.comparer);
        int index = 0;
        IEnumerable<TSource> enumerable;
        while ((enumerable = this.getEnumerable(index)) != null) {
            try (IEnumerator<TSource> e = enumerable.enumerator();){
                while (e.moveNext()) {
                    TSource element = e.current();
                    if (!set.add(this.keySelector.apply(element))) continue;
                    builder.add(element);
                }
            }
            ++index;
        }
        return builder.toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        LargeArrayBuilder<TSource> builder = new LargeArrayBuilder<TSource>();
        Set<TKey> set = new Set<TKey>(this.comparer);
        int index = 0;
        IEnumerable<TSource> enumerable;
        while ((enumerable = this.getEnumerable(index)) != null) {
            try (IEnumerator<TSource> e = enumerable.enumerator();){
                while (e.moveNext()) {
                    TSource element = e.current();
                    if (!set.add(this.keySelector.apply(element))) continue;
                    builder.add(element);
                }
            }
            ++index;
        }
        return builder.toArray();
    }

    @Override
    public List<TSource> _toList() {
        ArrayList<TSource> list = new ArrayList<TSource>();
        Set<TKey> set = new Set<TKey>(this.comparer);
        int index = 0;
        IEnumerable<TSource> enumerable;
        while ((enumerable = this.getEnumerable(index)) != null) {
            try (IEnumerator<TSource> e = enumerable.enumerator();){
                while (e.moveNext()) {
                    TSource element = e.current();
                    if (!set.add(this.keySelector.apply(element))) continue;
                    list.add(element);
                }
            }
            ++index;
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        return onlyIfCheap ? -1 : this.fillSet().getCount();
    }
}

