/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SingleLinkedNode;
import com.bestvike.linq.enumerable.UnionByIterator;
import com.bestvike.linq.enumerable.UnionByIteratorN;

final class UnionByIterator2<TSource, TKey>
extends UnionByIterator<TSource, TKey> {
    private final IEnumerable<TSource> first;
    private final IEnumerable<TSource> second;

    UnionByIterator2(IEnumerable<TSource> first, IEnumerable<TSource> second, Func1<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer) {
        super(keySelector, comparer);
        assert (first != null);
        assert (second != null);
        this.first = first;
        this.second = second;
    }

    @Override
    public Iterator<TSource> clone() {
        return new UnionByIterator2<TSource, TKey>(this.first, this.second, this.keySelector, this.comparer);
    }

    @Override
    IEnumerable<TSource> getEnumerable(int index) {
        assert (index >= 0 && index <= 2);
        switch (index) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        return null;
    }

    @Override
    UnionByIterator<TSource, TKey> _unionBy(IEnumerable<TSource> next) {
        SingleLinkedNode<IEnumerable<TSource>> sources = new SingleLinkedNode<IEnumerable<IEnumerable<TSource>>>(this.first).add(this.second).add(next);
        return new UnionByIteratorN(sources, 2, this.keySelector, this.comparer);
    }
}

