/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IEqualityComparer;
import com.bestvike.function.Func1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.SingleLinkedNode;
import com.bestvike.linq.enumerable.UnionByIterator;
import com.bestvike.linq.enumerable.UnionByIterator2;

final class UnionByIteratorN<TSource, TKey>
extends UnionByIterator<TSource, TKey> {
    private final SingleLinkedNode<IEnumerable<TSource>> sources;
    private final int headIndex;

    UnionByIteratorN(SingleLinkedNode<IEnumerable<TSource>> sources, int headIndex, Func1<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer) {
        super(keySelector, comparer);
        assert (headIndex >= 2);
        assert (sources != null && sources.getCount() == headIndex + 1);
        this.sources = sources;
        this.headIndex = headIndex;
    }

    @Override
    public Iterator<TSource> clone() {
        return new UnionByIteratorN<TSource, TKey>(this.sources, this.headIndex, this.keySelector, this.comparer);
    }

    @Override
    IEnumerable<TSource> getEnumerable(int index) {
        return index > this.headIndex ? null : this.sources.getNode(this.headIndex - index).getItem();
    }

    @Override
    UnionByIterator<TSource, TKey> _unionBy(IEnumerable<TSource> next) {
        if (this.headIndex == 0x7FFFFFFD) {
            return new UnionByIterator2(this, next, this.keySelector, this.comparer);
        }
        return new UnionByIteratorN<TSource, TKey>(this.sources.add(next), this.headIndex + 1, this.keySelector, this.comparer);
    }
}

