/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.Comparer;
import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.exception.ThrowHelper;
import com.bestvike.linq.util.Formatter;
import com.bestvike.linq.util.Reflection;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class Values {
    private static final int HASH_PRIME = 31;
    private static final int HASH_NULL = 0;
    private static final int HASH_EMPTY = 1;
    private static final int HASH_TRUE = 1231;
    private static final int HASH_FALSE = 1237;
    private static final int DECIMAL_SCALE = 6;
    private static final RoundingMode DECIMAL_ROUNDING = RoundingMode.HALF_EVEN;
    private static final String JDK_PREFIX = "java";

    private Values() {
    }

    public static boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x instanceof BigDecimal && y instanceof BigDecimal) {
            return ((BigDecimal)x).compareTo((BigDecimal)y) == 0;
        }
        if (x instanceof boolean[]) {
            return Values.equals((boolean[])x, y);
        }
        if (x instanceof byte[]) {
            return Values.equals((byte[])x, y);
        }
        if (x instanceof short[]) {
            return Values.equals((short[])x, y);
        }
        if (x instanceof int[]) {
            return Values.equals((int[])x, y);
        }
        if (x instanceof long[]) {
            return Values.equals((long[])x, y);
        }
        if (x instanceof char[]) {
            return Values.equals((char[])x, y);
        }
        if (x instanceof float[]) {
            return Values.equals((float[])x, y);
        }
        if (x instanceof double[]) {
            return Values.equals((double[])x, y);
        }
        if (x instanceof Object[]) {
            return Values.equals((Object[])x, y);
        }
        if (x instanceof IEnumerable) {
            if (x instanceof ICollection) {
                ICollection collection = (ICollection)x;
                return Values.equals(collection, y, collection._getCount());
            }
            if (x instanceof IIListProvider) {
                IIListProvider listProvider = (IIListProvider)x;
                return Values.equals(listProvider, y, listProvider._getCount(true));
            }
            return Values.equals((IEnumerable)x, y, -1);
        }
        if (x instanceof Iterable) {
            if (x instanceof Collection) {
                Collection collection = (Collection)x;
                return Values.equals(collection, y, collection.size());
            }
            return Values.equals((Iterable)x, y, -1);
        }
        if (x instanceof Map) {
            return Values.equals((Map)x, y);
        }
        Class<?> clazz = x.getClass();
        if (clazz.getName().startsWith(JDK_PREFIX)) {
            return x.equals(y);
        }
        if (clazz != y.getClass()) {
            return false;
        }
        Field[] fields = Reflection.getFields(clazz);
        try {
            for (Field field : fields) {
                if (Values.equals(field.get(x), field.get(y))) continue;
                return false;
            }
        }
        catch (IllegalAccessException e) {
            ThrowHelper.throwRuntimeException(e);
        }
        return true;
    }

    private static boolean equals(boolean[] x, Object y) {
        if (y instanceof boolean[]) {
            boolean[] arrY = (boolean[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == arrY[i]) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Boolean.valueOf(x[i]).equals(arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                boolean[] blArray = x;
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    Boolean curX = blArray[i];
                    if (itY.moveNext() && curX.equals(itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            boolean[] blArray = x;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean curX = blArray[i];
                if (itY.hasNext() && curX.equals(itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static boolean equals(byte[] x, Object y) {
        if (y instanceof byte[]) {
            byte[] arrY = (byte[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == arrY[i]) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Byte.valueOf(x[i]).equals(arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                byte[] byArray = x;
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    Byte curX = byArray[i];
                    if (itY.moveNext() && curX.equals(itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            byte[] byArray = x;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte curX = byArray[i];
                if (itY.hasNext() && curX.equals(itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static boolean equals(short[] x, Object y) {
        if (y instanceof short[]) {
            short[] arrY = (short[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == arrY[i]) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Short.valueOf(x[i]).equals(arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                short[] sArray = x;
                int n = sArray.length;
                for (int i = 0; i < n; ++i) {
                    Short curX = sArray[i];
                    if (itY.moveNext() && curX.equals(itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            short[] sArray = x;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short curX = sArray[i];
                if (itY.hasNext() && curX.equals(itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static boolean equals(int[] x, Object y) {
        if (y instanceof int[]) {
            int[] arrY = (int[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == arrY[i]) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Integer.valueOf(x[i]).equals(arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                int[] nArray = x;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer curX = nArray[i];
                    if (itY.moveNext() && curX.equals(itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            int[] nArray = x;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer curX = nArray[i];
                if (itY.hasNext() && curX.equals(itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static boolean equals(long[] x, Object y) {
        if (y instanceof long[]) {
            long[] arrY = (long[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == arrY[i]) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Long.valueOf(x[i]).equals(arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                long[] lArray = x;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long curX = lArray[i];
                    if (itY.moveNext() && curX.equals(itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            long[] lArray = x;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long curX = lArray[i];
                if (itY.hasNext() && curX.equals(itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static boolean equals(char[] x, Object y) {
        if (y instanceof char[]) {
            char[] arrY = (char[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == arrY[i]) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Character.valueOf(x[i]).equals(arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                char[] cArray = x;
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    Character curX = Character.valueOf(cArray[i]);
                    if (itY.moveNext() && curX.equals(itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            char[] cArray = x;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character curX = Character.valueOf(cArray[i]);
                if (itY.hasNext() && curX.equals(itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static boolean equals(float[] x, Object y) {
        if (y instanceof float[]) {
            float[] arrY = (float[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == arrY[i]) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Float.valueOf(x[i]).equals(arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                float[] fArray = x;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    Float curX = Float.valueOf(fArray[i]);
                    if (itY.moveNext() && curX.equals(itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            float[] fArray = x;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float curX = Float.valueOf(fArray[i]);
                if (itY.hasNext() && curX.equals(itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static boolean equals(double[] x, Object y) {
        if (y instanceof double[]) {
            double[] arrY = (double[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i] == arrY[i]) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Double.valueOf(x[i]).equals(arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                double[] dArray = x;
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    Double curX = dArray[i];
                    if (itY.moveNext() && curX.equals(itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            double[] dArray = x;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double curX = dArray[i];
                if (itY.hasNext() && curX.equals(itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static <T> boolean equals(T[] x, Object y) {
        if (y instanceof boolean[]) {
            boolean[] arrY = (boolean[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Boolean.valueOf(arrY[i]).equals(x[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof byte[]) {
            byte[] arrY = (byte[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Byte.valueOf(arrY[i]).equals(x[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof short[]) {
            short[] arrY = (short[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Short.valueOf(arrY[i]).equals(x[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof int[]) {
            int[] arrY = (int[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Integer.valueOf(arrY[i]).equals(x[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof long[]) {
            long[] arrY = (long[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Long.valueOf(arrY[i]).equals(x[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof char[]) {
            char[] arrY = (char[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Character.valueOf(arrY[i]).equals(x[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof float[]) {
            float[] arrY = (float[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Float.valueOf(arrY[i]).equals(x[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof double[]) {
            double[] arrY = (double[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Double.valueOf(arrY[i]).equals(x[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (x.length != arrY.length) {
                return false;
            }
            for (int i = 0; i < x.length; ++i) {
                if (Values.equals(x[i], arrY[i])) continue;
                return false;
            }
            return true;
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (y instanceof ICollection ? x.length != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && x.length != lenY) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                for (T curX : x) {
                    if (itY.moveNext() && Values.equals(curX, itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (y instanceof Collection && x.length != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            for (T curX : x) {
                if (itY.hasNext() && Values.equals(curX, itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private static <T> boolean equals(IEnumerable<T> x, Object y, int lenX) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T> boolean equals(Iterable<T> x, Object y, int lenX) {
        if (y instanceof boolean[]) {
            boolean[] arrY = (boolean[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            boolean[] blArray = arrY;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean curY = blArray[i];
                if (itX.hasNext() && curY.equals(itX.next())) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof byte[]) {
            byte[] arrY = (byte[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            byte[] byArray = arrY;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte curY = byArray[i];
                if (itX.hasNext() && curY.equals(itX.next())) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof short[]) {
            short[] arrY = (short[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            short[] sArray = arrY;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short curY = sArray[i];
                if (itX.hasNext() && curY.equals(itX.next())) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof int[]) {
            int[] arrY = (int[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            int[] nArray = arrY;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer curY = nArray[i];
                if (itX.hasNext() && curY.equals(itX.next())) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof long[]) {
            long[] arrY = (long[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            long[] lArray = arrY;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long curY = lArray[i];
                if (itX.hasNext() && curY.equals(itX.next())) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof char[]) {
            char[] arrY = (char[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            char[] cArray = arrY;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character curY = Character.valueOf(cArray[i]);
                if (itX.hasNext() && curY.equals(itX.next())) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof float[]) {
            float[] arrY = (float[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            float[] fArray = arrY;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float curY = Float.valueOf(fArray[i]);
                if (itX.hasNext() && curY.equals(itX.next())) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof double[]) {
            double[] arrY = (double[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            double[] dArray = arrY;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double curY = dArray[i];
                if (itX.hasNext() && curY.equals(itX.next())) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof Object[]) {
            Object[] arrY = (Object[])y;
            if (lenX != -1 && lenX != arrY.length) {
                return false;
            }
            Iterator<T> itX = x.iterator();
            for (Object curY : arrY) {
                if (itX.hasNext() && Values.equals(itX.next(), curY)) continue;
                return false;
            }
            return !itX.hasNext();
        }
        if (y instanceof IEnumerable) {
            int lenY;
            IEnumerable listY;
            if (lenX != -1 && (y instanceof ICollection ? lenX != (listY = (ICollection)y)._getCount() : y instanceof IIListProvider && (lenY = (listY = (IIListProvider)y)._getCount(true)) != -1 && lenX != lenY)) {
                return false;
            }
            try (IEnumerator itY = ((IEnumerable)y).enumerator();){
                for (T curX : x) {
                    if (itY.moveNext() && Values.equals(curX, itY.current())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !itY.moveNext();
                return bl;
            }
        }
        if (y instanceof Iterable) {
            Collection listY;
            if (lenX != -1 && y instanceof Collection && lenX != (listY = (Collection)y).size()) {
                return false;
            }
            Iterator itY = ((Iterable)y).iterator();
            for (T curX : x) {
                if (itY.hasNext() && Values.equals(curX, itY.next())) continue;
                return false;
            }
            return !itY.hasNext();
        }
        return false;
    }

    private static <K, V> boolean equals(Map<K, V> x, Object y) {
        if (y instanceof Map) {
            Map mapY = (Map)y;
            if (x.size() != mapY.size()) {
                return false;
            }
            for (Map.Entry<K, V> entry : x.entrySet()) {
                if (Values.equals(entry.getValue(), mapY.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).setScale(6, DECIMAL_ROUNDING).hashCode();
        }
        if (obj instanceof boolean[]) {
            return Values.hashCode((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Values.hashCode((byte[])obj);
        }
        if (obj instanceof short[]) {
            return Values.hashCode((short[])obj);
        }
        if (obj instanceof int[]) {
            return Values.hashCode((int[])obj);
        }
        if (obj instanceof long[]) {
            return Values.hashCode((long[])obj);
        }
        if (obj instanceof char[]) {
            return Values.hashCode((char[])obj);
        }
        if (obj instanceof float[]) {
            return Values.hashCode((float[])obj);
        }
        if (obj instanceof double[]) {
            return Values.hashCode((double[])obj);
        }
        if (obj instanceof Object[]) {
            return Values.hashCode((Object[])obj);
        }
        if (obj instanceof IEnumerable) {
            return Values.hashCode((IEnumerable)obj);
        }
        if (obj instanceof Iterable) {
            return Values.hashCode((Iterable)obj);
        }
        if (obj instanceof Map) {
            return Values.hashCode((Map)obj);
        }
        Class<?> clazz = obj.getClass();
        if (clazz.getName().startsWith(JDK_PREFIX)) {
            return obj.hashCode();
        }
        int result = 1;
        Field[] fields = Reflection.getFields(clazz);
        try {
            for (Field field : fields) {
                result = 31 * result + Values.hashCode(field.get(obj));
            }
        }
        catch (IllegalAccessException e) {
            ThrowHelper.throwRuntimeException(e);
        }
        return result;
    }

    private static int hashCode(boolean[] obj) {
        int result = 1;
        for (boolean element : obj) {
            result = 31 * result + (element ? 1231 : 1237);
        }
        return result;
    }

    private static int hashCode(byte[] obj) {
        int result = 1;
        for (byte element : obj) {
            result = 31 * result + element;
        }
        return result;
    }

    private static int hashCode(short[] obj) {
        int result = 1;
        for (short element : obj) {
            result = 31 * result + element;
        }
        return result;
    }

    private static int hashCode(int[] obj) {
        int result = 1;
        for (int element : obj) {
            result = 31 * result + element;
        }
        return result;
    }

    private static int hashCode(long[] obj) {
        int result = 1;
        for (long element : obj) {
            result = 31 * result + (int)(element ^ element >>> 32);
        }
        return result;
    }

    private static int hashCode(char[] obj) {
        int result = 1;
        for (char element : obj) {
            result = 31 * result + element;
        }
        return result;
    }

    private static int hashCode(float[] obj) {
        int result = 1;
        for (float element : obj) {
            result = 31 * result + Float.floatToIntBits(element);
        }
        return result;
    }

    private static int hashCode(double[] obj) {
        int result = 1;
        for (double element : obj) {
            long bits = Double.doubleToLongBits(element);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    private static <T> int hashCode(T[] obj) {
        int result = 1;
        for (T element : obj) {
            result = 31 * result + Values.hashCode(element);
        }
        return result;
    }

    private static <T> int hashCode(IEnumerable<T> obj) {
        int result = 1;
        try (IEnumerator<T> e = obj.enumerator();){
            while (e.moveNext()) {
                result = 31 * result + Values.hashCode(e.current());
            }
        }
        return result;
    }

    private static <T> int hashCode(Iterable<T> obj) {
        int result = 1;
        for (T element : obj) {
            result = 31 * result + Values.hashCode(element);
        }
        return result;
    }

    private static <K, V> int hashCode(Map<K, V> obj) {
        int result = 1;
        TreeMap treeMap = new TreeMap(Comparer.Default());
        treeMap.putAll(obj);
        for (Map.Entry entry : treeMap.entrySet()) {
            result = 31 * result + Values.hashCode(entry.getKey());
            result = 31 * result + Values.hashCode(entry.getValue());
        }
        return result;
    }

    public static String toString(Object obj) {
        return Formatter.DEFAULT.format(obj);
    }
}

