/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArray;
import com.bestvike.collections.generic.IArrayList;
import com.bestvike.function.IndexPredicate2;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.EmptyPartition;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.WhereArrayIterator;
import com.bestvike.linq.enumerable.WhereEnumerableIterator;
import com.bestvike.linq.enumerable.WhereIterator;
import com.bestvike.linq.enumerable.WhereListIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Where {
    private Where() {
    }

    public static <TSource> IEnumerable<TSource> where(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        if (source instanceof Iterator) {
            Iterator iterator = (Iterator)source;
            return iterator._where(predicate);
        }
        if (source instanceof IArray) {
            IArray array = (IArray)source;
            return array._getCount() == 0 ? EmptyPartition.instance() : new WhereArrayIterator<TSource>(array, predicate);
        }
        if (source instanceof IArrayList) {
            IArrayList list = (IArrayList)source;
            return new WhereListIterator<TSource>(list, predicate);
        }
        return new WhereEnumerableIterator<TSource>(source, predicate);
    }

    public static <TSource> IEnumerable<TSource> where(IEnumerable<TSource> source, IndexPredicate2<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        return new WhereIterator<TSource>(source, predicate);
    }
}

