/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArrayList;
import com.bestvike.function.Func1;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.enumerable.WhereSelectListIterator;
import com.bestvike.linq.util.Utilities;
import java.util.ArrayList;
import java.util.List;

final class WhereListIterator<TSource>
extends Iterator<TSource>
implements IIListProvider<TSource> {
    private final IArrayList<TSource> source;
    private final Predicate1<TSource> predicate;
    private IEnumerator<TSource> enumerator;

    WhereListIterator(IArrayList<TSource> source, Predicate1<TSource> predicate) {
        assert (source != null);
        assert (predicate != null);
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public Iterator<TSource> clone() {
        return new WhereListIterator<TSource>(this.source, this.predicate);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                while (this.enumerator.moveNext()) {
                    TSource item = this.enumerator.current();
                    if (!this.predicate.apply(item)) continue;
                    this.current = item;
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }

    @Override
    public <TResult> IEnumerable<TResult> _select(Func1<TSource, TResult> selector) {
        return new WhereSelectListIterator<TSource, TResult>(this.source, this.predicate, selector);
    }

    @Override
    public IEnumerable<TSource> _where(Predicate1<TSource> predicate) {
        return new WhereListIterator<TSource>(this.source, Utilities.combinePredicates(this.predicate, predicate));
    }

    @Override
    public TSource[] _toArray(Class<TSource> clazz) {
        int count = this.source._getCount();
        LargeArrayBuilder<Object> builder = new LargeArrayBuilder<Object>(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            builder.add(item);
        }
        return builder.toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        int count = this.source._getCount();
        LargeArrayBuilder builder = new LargeArrayBuilder(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            builder.add(item);
        }
        return builder.toArray();
    }

    @Override
    public List<TSource> _toList() {
        ArrayList list = new ArrayList();
        int count = this.source._getCount();
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            list.add(item);
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            return -1;
        }
        int count = 0;
        int length = this.source._getCount();
        for (int i = 0; i < length; ++i) {
            if (!this.predicate.apply(this.source.get(i))) continue;
            count = Math.addExact(count, 1);
        }
        return count;
    }
}

