/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.IArray;
import com.bestvike.function.Func1;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.util.Utilities;
import java.util.ArrayList;
import java.util.List;

final class WhereSelectArrayIterator<TSource, TResult>
extends Iterator<TResult>
implements IIListProvider<TResult> {
    private final IArray<TSource> source;
    private final Predicate1<TSource> predicate;
    private final Func1<TSource, TResult> selector;

    WhereSelectArrayIterator(IArray<TSource> source, Predicate1<TSource> predicate, Func1<TSource, TResult> selector) {
        assert (source != null && source._getCount() > 0);
        assert (predicate != null);
        assert (selector != null);
        this.source = source;
        this.predicate = predicate;
        this.selector = selector;
    }

    @Override
    public Iterator<TResult> clone() {
        return new WhereSelectArrayIterator<TSource, TResult>(this.source, this.predicate, this.selector);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        while (Integer.compareUnsigned(index, this.source._getCount()) < 0) {
            Object item = this.source.get(index);
            ++this.state;
            if (!this.predicate.apply(item)) continue;
            this.current = this.selector.apply(item);
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new WhereSelectArrayIterator<TSource, TResult2>(this.source, this.predicate, Utilities.combineSelectors(this.selector, selector));
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        int count = this.source._getCount();
        LargeArrayBuilder<TResult> builder = new LargeArrayBuilder<TResult>(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            builder.add(this.selector.apply(item));
        }
        return builder.toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        int count = this.source._getCount();
        LargeArrayBuilder<TResult> builder = new LargeArrayBuilder<TResult>(count);
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            builder.add(this.selector.apply(item));
        }
        return builder.toArray();
    }

    @Override
    public List<TResult> _toList() {
        ArrayList<TResult> list = new ArrayList<TResult>();
        int count = this.source._getCount();
        for (int i = 0; i < count; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            list.add(this.selector.apply(item));
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            return -1;
        }
        int count = 0;
        int length = this.source._getCount();
        for (int i = 0; i < length; ++i) {
            Object item = this.source.get(i);
            if (!this.predicate.apply(item)) continue;
            this.selector.apply(item);
            count = Math.addExact(count, 1);
        }
        return count;
    }
}

