/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.Iterator;
import com.bestvike.linq.enumerable.LargeArrayBuilder;
import com.bestvike.linq.util.Utilities;
import java.util.ArrayList;
import java.util.List;

final class WhereSelectEnumerableIterator<TSource, TResult>
extends Iterator<TResult>
implements IIListProvider<TResult> {
    private final IEnumerable<TSource> source;
    private final Predicate1<TSource> predicate;
    private final Func1<TSource, TResult> selector;
    private IEnumerator<TSource> enumerator;

    WhereSelectEnumerableIterator(IEnumerable<TSource> source, Predicate1<TSource> predicate, Func1<TSource, TResult> selector) {
        assert (source != null);
        assert (predicate != null);
        assert (selector != null);
        this.source = source;
        this.predicate = predicate;
        this.selector = selector;
    }

    @Override
    public Iterator<TResult> clone() {
        return new WhereSelectEnumerableIterator<TSource, TResult>(this.source, this.predicate, this.selector);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                while (this.enumerator.moveNext()) {
                    TSource item = this.enumerator.current();
                    if (!this.predicate.apply(item)) continue;
                    this.current = this.selector.apply(item);
                    return true;
                }
                this.close();
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }

    @Override
    public <TResult2> IEnumerable<TResult2> _select(Func1<TResult, TResult2> selector) {
        return new WhereSelectEnumerableIterator<TSource, TResult2>(this.source, this.predicate, Utilities.combineSelectors(this.selector, selector));
    }

    @Override
    public TResult[] _toArray(Class<TResult> clazz) {
        LargeArrayBuilder<TResult> builder = new LargeArrayBuilder<TResult>();
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                TSource item = e.current();
                if (!this.predicate.apply(item)) continue;
                builder.add(this.selector.apply(item));
            }
        }
        return builder.toArray(clazz);
    }

    @Override
    public Object[] _toArray() {
        LargeArrayBuilder<TResult> builder = new LargeArrayBuilder<TResult>();
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                TSource item = e.current();
                if (!this.predicate.apply(item)) continue;
                builder.add(this.selector.apply(item));
            }
        }
        return builder.toArray();
    }

    @Override
    public List<TResult> _toList() {
        ArrayList<TResult> list = new ArrayList<TResult>();
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                TSource item = e.current();
                if (!this.predicate.apply(item)) continue;
                list.add(this.selector.apply(item));
            }
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (onlyIfCheap) {
            return -1;
        }
        int count = 0;
        try (IEnumerator<TSource> e = this.source.enumerator();){
            while (e.moveNext()) {
                TSource item = e.current();
                if (!this.predicate.apply(item)) continue;
                this.selector.apply(item);
                count = Math.addExact(count, 1);
            }
        }
        return count;
    }
}

