/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.exception;

import com.bestvike.linq.exception.ArgumentException;
import com.bestvike.linq.exception.ArgumentNullException;
import com.bestvike.linq.exception.ArgumentOutOfRangeException;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.InvalidOperationException;
import com.bestvike.linq.exception.NotSupportedException;
import com.bestvike.linq.exception.RepeatInvokeException;
import java.util.NoSuchElementException;

public final class ThrowHelper {
    private ThrowHelper() {
    }

    public static void throwArgumentNullException(ExceptionArgument argument) {
        throw new ArgumentNullException(ThrowHelper.getArgumentString(argument));
    }

    public static void throwArgumentOutOfRangeException(ExceptionArgument argument) {
        throw new ArgumentOutOfRangeException(ThrowHelper.getArgumentString(argument));
    }

    public static void throwMoreThanOneElementException() {
        throw new InvalidOperationException("Sequence contains more than one element.");
    }

    public static void throwMoreThanOneMatchException() {
        throw new InvalidOperationException("Sequence contains more than one matching element.");
    }

    public static void throwNoElementsException() {
        throw new InvalidOperationException("Sequence contains no elements.");
    }

    public static void throwNoMatchException() {
        throw new InvalidOperationException("Sequence contains no matching element.");
    }

    public static void throwNotSupportedException() {
        throw new NotSupportedException();
    }

    public static void throwRepeatInvokeException() {
        throw new RepeatInvokeException();
    }

    public static void throwNoSuchElementException() {
        throw new NoSuchElementException("Sequence contains no such element.");
    }

    public static void throwIndexOutOfRangeException() {
        throw new IndexOutOfBoundsException("Index was outside the bounds of the array.");
    }

    public static void throwImplementComparableException() {
        throw new ArgumentException("At least one object must implement Comparable.");
    }

    public static void throwTupleIncorrectTypeException(Class type, ExceptionArgument argument) {
        throw new ArgumentException(String.format("Argument must be of type %s.", type), ThrowHelper.getArgumentString(argument));
    }

    public static void throwTupleLastArgumentNotATupleException() {
        throw new ArgumentException("The last element of an eight element tuple must be a Tuple.");
    }

    public static void throwRuntimeException(Throwable cause) {
        throw new RuntimeException(cause);
    }

    public static void throwNullPointerException() {
        throw new NullPointerException();
    }

    private static String getArgumentString(ExceptionArgument argument) {
        if (argument == null) {
            assert (false) : "The ExceptionArgument value is not defined.";
            return "";
        }
        return argument.name();
    }
}

