/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.util;

import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Reflection {
    private static final Map<Class<?>, Field[]> CLASS_FIELDS_MAP = new ConcurrentHashMap();

    private Reflection() {
    }

    public static Field[] getFields(Class<?> clazz) {
        if (clazz == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.clazz);
        }
        return CLASS_FIELDS_MAP.computeIfAbsent(clazz, cls -> {
            ArrayList<Field> fields = new ArrayList<Field>();
            while (cls != Object.class) {
                Field[] declaredFields;
                for (Field field : declaredFields = cls.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    fields.add(field);
                }
                cls = cls.getSuperclass();
            }
            return fields.toArray(new Field[fields.size()]);
        });
    }
}

