/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike;

import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Index {
    public static final Index Start = new Index(0);
    public static final Index End = new Index(-1);
    private final int value;

    private Index(int value) {
        this.value = value;
    }

    public Index(int value, boolean fromEnd) {
        if (value < 0) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.value);
        }
        this.value = fromEnd ? ~value : value;
    }

    public static Index fromStart(int value) {
        if (value < 0) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.value);
        }
        return new Index(value);
    }

    public static Index fromEnd(int value) {
        if (value < 0) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.value);
        }
        return new Index(~value);
    }

    public int getValue() {
        if (this.value < 0) {
            return ~this.value;
        }
        return this.value;
    }

    public boolean isFromEnd() {
        return this.value < 0;
    }

    public int getOffset(int length) {
        int offset = this.value;
        if (this.isFromEnd()) {
            offset += length + 1;
        }
        return offset;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Index) {
            return this.value == ((Index)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    protected Index clone() {
        return new Index(this.value);
    }

    public String toString() {
        if (this.isFromEnd()) {
            return this.toStringFromEnd();
        }
        return String.valueOf(this.value);
    }

    private String toStringFromEnd() {
        return '^' + String.valueOf(this.getValue());
    }
}

