/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike;

import com.bestvike.Index;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Range {
    public static final Range All = new Range(Index.Start, Index.End);
    private final Index start;
    private final Index end;

    public Range(Index start, Index end) {
        if (start == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.start);
        }
        if (end == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.end);
        }
        this.start = start;
        this.end = end;
    }

    public static Range startAt(Index start) {
        return new Range(start, Index.End);
    }

    public static Range endAt(Index end) {
        return new Range(Index.Start, end);
    }

    public Index getStart() {
        return this.start;
    }

    public Index getEnd() {
        return this.end;
    }

    public OffsetLength getOffsetAndLength(int length) {
        Index startIndex = this.getStart();
        int start = startIndex.isFromEnd() ? length - startIndex.getValue() : startIndex.getValue();
        Index endIndex = this.getEnd();
        int end = endIndex.isFromEnd() ? length - endIndex.getValue() : endIndex.getValue();
        if (Integer.compareUnsigned(end, length) > 0 || Integer.compareUnsigned(start, end) > 0) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.length);
        }
        return new OffsetLength(start, end - start);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Range) {
            Range r = (Range)obj;
            return this.start.equals(r.start) && this.end.equals(r.end);
        }
        return false;
    }

    public int hashCode() {
        int h1 = this.start.hashCode();
        int h2 = this.end.hashCode();
        return (h1 << 5) + h1 ^ h2;
    }

    protected Range clone() {
        return new Range(this.start, this.end);
    }

    public String toString() {
        return this.start.toString() + ".." + this.end.toString();
    }

    public static final class OffsetLength {
        public final int Offset;
        public final int Length;

        public OffsetLength(int offset, int length) {
            this.Offset = offset;
            this.Length = length;
        }
    }
}

