/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.debug;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.Linq;
import com.bestvike.linq.debug.CollectionDebugView;
import com.bestvike.linq.debug.DebuggerDisplay;
import com.bestvike.linq.debug.DebuggerTypeProxy;
import com.bestvike.linq.debug.EnumerableDebugView;
import com.bestvike.linq.debug.IDebugView;
import com.bestvike.linq.debug.IterableDebugView;
import com.bestvike.linq.debug.MapDebugView;
import com.bestvike.linq.debug.ObjectDebugView;
import com.bestvike.linq.exception.InvalidOperationException;
import com.bestvike.out;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Map;

final class Debugger {
    private Debugger() {
    }

    static String getDebuggerDisplayText(Object obj) {
        Class<?> objType = obj.getClass();
        DebuggerDisplay debuggerDisplay = objType.getAnnotation(DebuggerDisplay.class);
        if (debuggerDisplay == null) {
            if (objType.isArray()) {
                return "Count = " + Array.getLength(obj);
            }
            if (obj instanceof Collection) {
                return "Count = " + ((Collection)obj).size();
            }
            if (obj instanceof Map) {
                return "Count = " + ((Map)obj).size();
            }
            if (obj instanceof ICollection) {
                return "Count = " + ((ICollection)obj)._getCount();
            }
            return objType.getName();
        }
        String attrText = debuggerDisplay.value();
        String[] segments = Linq.split((CharSequence)attrText, '{', '}').toArray(String.class);
        if (segments.length % 2 == 0) {
            throw new InvalidOperationException(String.format("The DebuggerDisplay for %s lacks a closing brace.", objType));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < segments.length; i += 2) {
            out<Object> memberRef;
            String literal = segments[i];
            sb.append(literal);
            if (i + 1 >= segments.length) continue;
            String reference = segments[i + 1];
            boolean noQuotes = reference.endsWith(",nq");
            if (noQuotes) {
                reference = reference.substring(0, reference.length() - 3);
            }
            if (!Debugger.tryEvaluateReference(obj, reference, memberRef = out.init())) {
                throw new InvalidOperationException(String.format("The DebuggerDisplay for %s contains the expression \"%s\".", objType, reference));
            }
            String memberString = Debugger.getDebuggerMemberString(memberRef.value, noQuotes);
            sb.append(memberString);
        }
        return sb.toString();
    }

    private static String getDebuggerMemberString(Object member, boolean noQuotes) {
        if (member == null) {
            return "null";
        }
        if (member instanceof String) {
            return noQuotes ? (String)member : '\"' + (String)member + '\"';
        }
        if (Debugger.isPrimitiveType(member)) {
            return member.toString();
        }
        return '{' + member.toString() + '}';
    }

    private static boolean isPrimitiveType(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Character.class || clazz == Float.class || clazz == Double.class;
    }

    private static boolean tryEvaluateReference(Object obj, String reference, out<Object> memberRef) {
        if (reference.endsWith("()")) {
            Method method = Debugger.getMethod(obj, reference.substring(0, reference.length() - 2));
            if (method != null) {
                try {
                    memberRef.value = Modifier.isStatic(method.getModifiers()) ? method.invoke(null, new Object[0]) : method.invoke(obj, new Object[0]);
                    return true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            Field field = Debugger.getField(obj, reference);
            if (field != null) {
                try {
                    memberRef.value = Modifier.isStatic(field.getModifiers()) ? field.get(null) : field.get(obj);
                    return true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        memberRef.value = null;
        return false;
    }

    private static Field getField(Object obj, String fieldName) {
        for (Class<?> t = obj.getClass(); t != null; t = t.getSuperclass()) {
            try {
                Field field = t.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static Method getMethod(Object obj, String propertyName) {
        for (Class<?> t = obj.getClass(); t != null; t = t.getSuperclass()) {
            try {
                Method method = t.getDeclaredMethod(propertyName, new Class[0]);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    static IDebugView getDebugView(Object obj) {
        Class<?> objType = obj.getClass();
        Class<? extends IDebugView> proxyType = Debugger.getProxyType(objType);
        for (Constructor<?> constructor : proxyType.getDeclaredConstructors()) {
            Parameter[] parameters = constructor.getParameters();
            if (parameters.length != 1 || !parameters[0].getType().isAssignableFrom(objType)) continue;
            try {
                constructor.setAccessible(true);
                return (IDebugView)constructor.newInstance(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new InvalidOperationException(String.format("The DebuggerTypeProxy for %s reference invalid proxyType %s", objType, proxyType));
    }

    private static Class<? extends IDebugView> getProxyType(Class<?> type) {
        DebuggerTypeProxy debuggerTypeProxy = type.getAnnotation(DebuggerTypeProxy.class);
        if (debuggerTypeProxy != null) {
            return debuggerTypeProxy.value();
        }
        if (IEnumerable.class.isAssignableFrom(type)) {
            return EnumerableDebugView.class;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return CollectionDebugView.class;
        }
        if (Map.class.isAssignableFrom(type)) {
            return MapDebugView.class;
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return IterableDebugView.class;
        }
        return ObjectDebugView.class;
    }
}

