/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

abstract class AbstractEnumerableSorter<TElement> {
    AbstractEnumerableSorter() {
    }

    protected abstract void computeKeys(Object[] var1, int var2);

    protected abstract int compareAnyKeys(int var1, int var2);

    private Integer[] computeMap(Object[] elements, int count) {
        this.computeKeys(elements, count);
        Integer[] map = new Integer[count];
        for (int i = 0; i < map.length; ++i) {
            map[i] = i;
        }
        return map;
    }

    protected Integer[] sort(Object[] elements, int count) {
        Integer[] map = this.computeMap(elements, count);
        this.quickSort(map, 0, count - 1);
        return map;
    }

    protected Integer[] sort(Object[] elements, int count, int minIdx, int maxIdx) {
        Integer[] map = this.computeMap(elements, count);
        this.partialQuickSort(map, 0, count - 1, minIdx, maxIdx);
        return map;
    }

    protected TElement elementAt(Object[] elements, int count, int idx) {
        Integer[] map = this.computeMap(elements, count);
        return (TElement)(idx == 0 ? elements[this.min(map, count)] : elements[this.quickSelect(map, count - 1, idx)]);
    }

    protected abstract void quickSort(Integer[] var1, int var2, int var3);

    protected abstract void partialQuickSort(Integer[] var1, int var2, int var3, int var4, int var5);

    protected abstract int quickSelect(Integer[] var1, int var2, int var3);

    protected abstract int min(Integer[] var1, int var2);
}

