/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.function.Func1;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.IOrderedEnumerable;
import com.bestvike.linq.enumerable.AbstractCachingComparer;
import com.bestvike.linq.enumerable.AbstractEnumerableSorter;
import com.bestvike.linq.enumerable.AbstractEnumerator;
import com.bestvike.linq.enumerable.Buffer;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.enumerable.IPartition;
import com.bestvike.linq.enumerable.OrderedEnumerable;
import com.bestvike.linq.enumerable.OrderedPartition;
import com.bestvike.linq.util.ArrayUtils;
import com.bestvike.linq.util.ListUtils;
import com.bestvike.out;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

abstract class AbstractOrderedEnumerable<TElement>
implements IOrderedEnumerable<TElement>,
IPartition<TElement> {
    IEnumerable<TElement> source;

    AbstractOrderedEnumerable() {
    }

    private Integer[] sortedMap(Buffer<TElement> buffer) {
        return this.getEnumerableSorter().sort(buffer.items, buffer.count);
    }

    private Integer[] sortedMap(Buffer<TElement> buffer, int minIdx, int maxIdx) {
        return this.getEnumerableSorter().sort(buffer.items, buffer.count, minIdx, maxIdx);
    }

    @Override
    public IEnumerator<TElement> enumerator() {
        return new OrderedEnumerableEnumerator();
    }

    public IEnumerator<TElement> enumerator(int minIdx, int maxIdx) {
        return new OrderedEnumerableRangeEnumerator(minIdx, maxIdx);
    }

    private AbstractEnumerableSorter<TElement> getEnumerableSorter() {
        return this.getEnumerableSorter(null);
    }

    protected abstract AbstractEnumerableSorter<TElement> getEnumerableSorter(AbstractEnumerableSorter<TElement> var1);

    private AbstractCachingComparer<TElement> getComparer() {
        return this.getComparer(null);
    }

    protected abstract AbstractCachingComparer<TElement> getComparer(AbstractCachingComparer<TElement> var1);

    @Override
    public <TKey> IOrderedEnumerable<TElement> createOrderedEnumerable(Func1<TElement, TKey> keySelector, Comparator<TKey> comparer, boolean descending) {
        return new OrderedEnumerable<TElement, TKey>(this.source, keySelector, comparer, descending, this);
    }

    public TElement _tryGetFirst(Predicate1<TElement> predicate, out<Boolean> found) {
        AbstractCachingComparer<TElement> comparer = this.getComparer();
        try (IEnumerator<TElement> e = this.source.enumerator();){
            TElement value;
            do {
                if (e.moveNext()) continue;
                found.value = false;
                TElement TElement = null;
                return TElement;
            } while (!predicate.apply(value = e.current()));
            comparer.setElement(value);
            while (e.moveNext()) {
                TElement x = e.current();
                if (!predicate.apply(x) || comparer.compare(x, true) >= 0) continue;
                value = x;
            }
            found.value = true;
            TElement TElement = value;
            return TElement;
        }
    }

    public TElement _tryGetLast(Predicate1<TElement> predicate, out<Boolean> found) {
        AbstractCachingComparer<TElement> comparer = this.getComparer();
        try (IEnumerator<TElement> e = this.source.enumerator();){
            TElement value;
            do {
                if (e.moveNext()) continue;
                found.value = false;
                TElement TElement = null;
                return TElement;
            } while (!predicate.apply(value = e.current()));
            comparer.setElement(value);
            while (e.moveNext()) {
                TElement x = e.current();
                if (!predicate.apply(x) || comparer.compare(x, false) < 0) continue;
                value = x;
            }
            found.value = true;
            TElement TElement = value;
            return TElement;
        }
    }

    @Override
    public TElement[] _toArray(Class<TElement> clazz) {
        Buffer<TElement> buffer = new Buffer<TElement>(this.source);
        int count = buffer.count;
        if (count == 0) {
            return buffer.toArray(clazz);
        }
        TElement[] array = ArrayUtils.newInstance(clazz, count);
        Integer[] map = this.sortedMap(buffer);
        for (int i = 0; i != array.length; ++i) {
            array[i] = buffer.items[map[i]];
        }
        return array;
    }

    @Override
    public Object[] _toArray() {
        Buffer<TElement> buffer = new Buffer<TElement>(this.source);
        int count = buffer.count;
        if (count == 0) {
            return buffer.items;
        }
        Object[] array = new Object[count];
        Integer[] map = this.sortedMap(buffer);
        for (int i = 0; i != array.length; ++i) {
            array[i] = buffer.items[map[i]];
        }
        return array;
    }

    @Override
    public List<TElement> _toList() {
        Buffer<TElement> buffer = new Buffer<TElement>(this.source);
        int count = buffer.count;
        ArrayList<Object> list = new ArrayList<Object>(count);
        if (count > 0) {
            Integer[] map = this.sortedMap(buffer);
            for (int i = 0; i != count; ++i) {
                list.add(buffer.items[map[i]]);
            }
        }
        return list;
    }

    @Override
    public int _getCount(boolean onlyIfCheap) {
        if (this.source instanceof IIListProvider) {
            IIListProvider listProv = (IIListProvider)this.source;
            return listProv._getCount(onlyIfCheap);
        }
        return !onlyIfCheap || this.source instanceof ICollection ? this.source.count() : -1;
    }

    public TElement[] _toArray(Class<TElement> clazz, int minIdx, int maxIdx) {
        Buffer<TElement> buffer = new Buffer<TElement>(this.source);
        int count = buffer.count;
        if (count <= minIdx) {
            return ArrayUtils.empty(clazz);
        }
        if (count <= maxIdx) {
            maxIdx = count - 1;
        }
        if (minIdx == maxIdx) {
            return ArrayUtils.singleton(clazz, this.getEnumerableSorter().elementAt(buffer.items, count, minIdx));
        }
        Integer[] map = this.sortedMap(buffer, minIdx, maxIdx);
        TElement[] array = ArrayUtils.newInstance(clazz, maxIdx - minIdx + 1);
        int idx = 0;
        while (minIdx <= maxIdx) {
            array[idx] = buffer.items[map[minIdx]];
            ++idx;
            ++minIdx;
        }
        return array;
    }

    public Object[] _toArray(int minIdx, int maxIdx) {
        Buffer<TElement> buffer = new Buffer<TElement>(this.source);
        int count = buffer.count;
        if (count <= minIdx) {
            return ArrayUtils.empty();
        }
        if (count <= maxIdx) {
            maxIdx = count - 1;
        }
        if (minIdx == maxIdx) {
            return ArrayUtils.singleton(this.getEnumerableSorter().elementAt(buffer.items, count, minIdx));
        }
        Integer[] map = this.sortedMap(buffer, minIdx, maxIdx);
        Object[] array = new Object[maxIdx - minIdx + 1];
        int idx = 0;
        while (minIdx <= maxIdx) {
            array[idx] = buffer.items[map[minIdx]];
            ++idx;
            ++minIdx;
        }
        return array;
    }

    public List<TElement> _toList(int minIdx, int maxIdx) {
        Buffer<TElement> buffer = new Buffer<TElement>(this.source);
        int count = buffer.count;
        if (count <= minIdx) {
            return ListUtils.empty();
        }
        if (count <= maxIdx) {
            maxIdx = count - 1;
        }
        if (minIdx == maxIdx) {
            return ListUtils.singleton(this.getEnumerableSorter().elementAt(buffer.items, count, minIdx));
        }
        Integer[] map = this.sortedMap(buffer, minIdx, maxIdx);
        ArrayList<Object> list = new ArrayList<Object>(maxIdx - minIdx + 1);
        while (minIdx <= maxIdx) {
            list.add(buffer.items[map[minIdx]]);
            ++minIdx;
        }
        return list;
    }

    public int _getCount(int minIdx, int maxIdx, boolean onlyIfCheap) {
        int count = this._getCount(onlyIfCheap);
        if (count <= 0) {
            return count;
        }
        if (count <= minIdx) {
            return 0;
        }
        return (count <= maxIdx ? count : maxIdx + 1) - minIdx;
    }

    @Override
    public IPartition<TElement> _skip(int count) {
        return new OrderedPartition(this, count, Integer.MAX_VALUE);
    }

    @Override
    public IPartition<TElement> _take(int count) {
        return new OrderedPartition(this, 0, count - 1);
    }

    @Override
    public TElement _tryGetElementAt(int index, out<Boolean> found) {
        if (index == 0) {
            return this._tryGetFirst(found);
        }
        if (index > 0) {
            Buffer<TElement> buffer = new Buffer<TElement>(this.source);
            int count = buffer.count;
            if (index < count) {
                found.value = true;
                return this.getEnumerableSorter().elementAt(buffer.items, count, index);
            }
        }
        found.value = false;
        return null;
    }

    @Override
    public TElement _tryGetFirst(out<Boolean> found) {
        AbstractCachingComparer<TElement> comparer = this.getComparer();
        try (IEnumerator<TElement> e = this.source.enumerator();){
            if (!e.moveNext()) {
                found.value = false;
                TElement TElement = null;
                return TElement;
            }
            TElement value = e.current();
            comparer.setElement(value);
            while (e.moveNext()) {
                TElement x = e.current();
                if (comparer.compare(x, true) >= 0) continue;
                value = x;
            }
            found.value = true;
            TElement TElement = value;
            return TElement;
        }
    }

    @Override
    public TElement _tryGetLast(out<Boolean> found) {
        try (IEnumerator<TElement> e = this.source.enumerator();){
            if (!e.moveNext()) {
                found.value = false;
                TElement TElement = null;
                return TElement;
            }
            AbstractCachingComparer<TElement> comparer = this.getComparer();
            TElement value = e.current();
            comparer.setElement(value);
            while (e.moveNext()) {
                TElement current = e.current();
                if (comparer.compare(current, false) < 0) continue;
                value = current;
            }
            found.value = true;
            TElement TElement = value;
            return TElement;
        }
    }

    public TElement _tryGetLast(int minIdx, int maxIdx, out<Boolean> found) {
        Buffer<TElement> buffer = new Buffer<TElement>(this.source);
        int count = buffer.count;
        if (minIdx >= count) {
            found.value = false;
            return null;
        }
        found.value = true;
        return maxIdx < count - 1 ? this.getEnumerableSorter().elementAt(buffer.items, count, maxIdx) : this._last(buffer);
    }

    private TElement _last(Buffer<TElement> buffer) {
        AbstractCachingComparer<Object> comparer = this.getComparer();
        Object[] items = buffer.items;
        int count = buffer.count;
        Object value = items[0];
        comparer.setElement(value);
        for (int i = 1; i != count; ++i) {
            Object x = items[i];
            if (comparer.compare(x, false) < 0) continue;
            value = x;
        }
        return (TElement)value;
    }

    private class OrderedEnumerableRangeEnumerator
    extends AbstractEnumerator<TElement> {
        private int minIdx;
        private int maxIdx;
        private Buffer<TElement> buffer;
        private Integer[] map;

        private OrderedEnumerableRangeEnumerator(int minIdx, int maxIdx) {
            this.minIdx = minIdx;
            this.maxIdx = maxIdx;
        }

        @Override
        public boolean moveNext() {
            switch (this.state) {
                case 0: {
                    this.buffer = new Buffer(AbstractOrderedEnumerable.this.source);
                    int count = this.buffer.count;
                    if (count <= this.minIdx) {
                        this.close();
                        return false;
                    }
                    if (count <= this.maxIdx) {
                        this.maxIdx = count - 1;
                    }
                    if (this.minIdx == this.maxIdx) {
                        this.current = AbstractOrderedEnumerable.this.getEnumerableSorter().elementAt(this.buffer.items, count, this.minIdx);
                        this.state = 2;
                        return true;
                    }
                    this.map = AbstractOrderedEnumerable.this.sortedMap(this.buffer, this.minIdx, this.maxIdx);
                    this.state = 1;
                }
                case 1: {
                    if (this.minIdx <= this.maxIdx) {
                        this.current = this.buffer.items[this.map[this.minIdx]];
                        ++this.minIdx;
                        return true;
                    }
                    this.map = null;
                    this.close();
                    return false;
                }
                case 2: {
                    this.close();
                    return false;
                }
            }
            return false;
        }

        @Override
        public void close() {
            this.buffer = null;
            this.map = null;
            super.close();
        }
    }

    private class OrderedEnumerableEnumerator
    extends AbstractEnumerator<TElement> {
        private Buffer<TElement> buffer;
        private Integer[] map;
        private int index;

        private OrderedEnumerableEnumerator() {
        }

        @Override
        public boolean moveNext() {
            switch (this.state) {
                case 0: {
                    this.buffer = new Buffer(AbstractOrderedEnumerable.this.source);
                    if (this.buffer.count <= 0) {
                        this.close();
                        return false;
                    }
                    this.map = AbstractOrderedEnumerable.this.sortedMap(this.buffer);
                    this.index = -1;
                    this.state = 1;
                }
                case 1: {
                    ++this.index;
                    if (this.index < this.buffer.count) {
                        this.current = this.buffer.items[this.map[this.index]];
                        return true;
                    }
                    this.close();
                    return false;
                }
            }
            return false;
        }

        @Override
        public void close() {
            this.buffer = null;
            this.map = null;
            super.close();
        }
    }
}

