/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.collections.generic.ICollection;
import com.bestvike.function.Predicate1;
import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.IIListProvider;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class AnyAll {
    private AnyAll() {
    }

    public static <TSource> boolean any(IEnumerable<TSource> source) {
        IIListProvider listProv;
        int count;
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (source instanceof ICollection) {
            ICollection collectionoft = (ICollection)source;
            return collectionoft._getCount() != 0;
        }
        if (source instanceof IIListProvider && (count = (listProv = (IIListProvider)source)._getCount(true)) >= 0) {
            return count != 0;
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            boolean bl = e.moveNext();
            return bl;
        }
    }

    public static <TSource> boolean any(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                if (!predicate.apply(e.current())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static <TSource> boolean all(IEnumerable<TSource> source, Predicate1<TSource> predicate) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (predicate == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.predicate);
        }
        try (IEnumerator<TSource> e = source.enumerator();){
            while (e.moveNext()) {
                if (predicate.apply(e.current())) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

