/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.util.ArrayUtils;

final class ArrayBuilder<T> {
    private static final int DefaultCapacity = 4;
    private static final int MaxArrayLength = 0x7FFFFFC7;
    private Object[] array;
    private int count;

    ArrayBuilder() {
    }

    ArrayBuilder(int capacity) {
        assert (capacity >= 0);
        if (capacity > 0) {
            this.array = new Object[capacity];
        }
    }

    public int getCapacity() {
        return this.array == null ? 0 : this.array.length;
    }

    public int getCount() {
        return this.count;
    }

    public T get(int index) {
        assert (index >= 0 && index < this.count);
        return (T)this.array[index];
    }

    public void set(int index, T value) {
        assert (index >= 0 && index < this.count);
        this.array[index] = value;
    }

    public void add(T item) {
        if (this.count == this.getCapacity()) {
            this.ensureCapacity(this.count + 1);
        }
        this.uncheckedAdd(item);
    }

    public T first() {
        assert (this.count > 0);
        return (T)this.array[0];
    }

    public T last() {
        assert (this.count > 0);
        return (T)this.array[this.count - 1];
    }

    public T[] toArray(Class<T> clazz) {
        if (this.count == 0) {
            return ArrayUtils.empty(clazz);
        }
        assert (this.array != null);
        return ArrayUtils.toArray(this.array, clazz, 0, this.count);
    }

    public Object[] toArray() {
        if (this.count == 0) {
            return ArrayUtils.empty();
        }
        assert (this.array != null);
        return ArrayUtils.resize(this.array, this.count);
    }

    public void uncheckedAdd(T item) {
        assert (this.count < this.getCapacity());
        this.array[this.count++] = item;
    }

    private void ensureCapacity(int minimum) {
        int nextCapacity;
        assert (minimum > this.getCapacity());
        int capacity = this.getCapacity();
        int n = nextCapacity = capacity == 0 ? 4 : 2 * capacity;
        if (Integer.compareUnsigned(nextCapacity, 0x7FFFFFC7) > 0) {
            nextCapacity = Math.max(capacity + 1, 0x7FFFFFC7);
        }
        nextCapacity = Math.max(nextCapacity, minimum);
        Object[] next = new Object[nextCapacity];
        if (this.count > 0) {
            System.arraycopy(this.array, 0, next, 0, this.count);
        }
        this.array = next;
    }
}

