/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.linq.enumerable.AbstractCachingComparer;
import java.util.Comparator;

class CachingComparer<TElement, TKey>
extends AbstractCachingComparer<TElement> {
    protected final Func1<TElement, TKey> keySelector;
    protected final Comparator<TKey> comparer;
    protected final boolean descending;
    protected TKey lastKey;

    CachingComparer(Func1<TElement, TKey> keySelector, Comparator<TKey> comparer, boolean descending) {
        this.keySelector = keySelector;
        this.comparer = comparer;
        this.descending = descending;
    }

    @Override
    int compare(TElement element, boolean cacheLower) {
        TKey newKey = this.keySelector.apply(element);
        int cmp = this.descending ? this.comparer.compare(this.lastKey, newKey) : this.comparer.compare(newKey, this.lastKey);
        if (cacheLower == cmp < 0) {
            this.lastKey = newKey;
        }
        return cmp;
    }

    @Override
    void setElement(TElement element) {
        this.lastKey = this.keySelector.apply(element);
    }
}

