/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.function.Func1;
import com.bestvike.linq.enumerable.AbstractCachingComparer;
import com.bestvike.linq.enumerable.CachingComparer;
import java.util.Comparator;

final class CachingComparerWithChild<TElement, TKey>
extends CachingComparer<TElement, TKey> {
    private final AbstractCachingComparer<TElement> child;

    CachingComparerWithChild(Func1<TElement, TKey> keySelector, Comparator<TKey> comparer, boolean descending, AbstractCachingComparer<TElement> child) {
        super(keySelector, comparer, descending);
        this.child = child;
    }

    @Override
    protected int compare(TElement element, boolean cacheLower) {
        int cmp;
        Object newKey = this.keySelector.apply(element);
        int n = cmp = this.descending ? this.comparer.compare(this.lastKey, newKey) : this.comparer.compare(newKey, this.lastKey);
        if (cmp == 0) {
            return this.child.compare(element, cacheLower);
        }
        if (cacheLower == cmp < 0) {
            this.lastKey = newKey;
            this.child.setElement(element);
        }
        return cmp;
    }

    @Override
    protected void setElement(TElement element) {
        super.setElement(element);
        this.child.setElement(element);
    }
}

