/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.CastIterator;
import com.bestvike.linq.enumerable.OfTypeIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Cast {
    private Cast() {
    }

    public static <TResult> IEnumerable<TResult> ofType(IEnumerable<?> source, Class<TResult> clazz) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (clazz == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.clazz);
        }
        return new OfTypeIterator<TResult>(source, clazz);
    }

    public static <TResult> IEnumerable<TResult> cast(IEnumerable<?> source, Class<TResult> clazz) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (clazz == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.clazz);
        }
        return new CastIterator<TResult>(source, clazz);
    }
}

