/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.util.lang.IStringSpan;

final class CharKeepEmptySplitIterator1
extends AbstractIterator<String> {
    private final IStringSpan source;
    private final char separator;
    private final boolean trimEntries;

    CharKeepEmptySplitIterator1(IStringSpan source, char separator, boolean trimEntries) {
        assert (source != null);
        this.source = source;
        this.separator = separator;
        this.trimEntries = trimEntries;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharKeepEmptySplitIterator1(this.source, this.separator, this.trimEntries);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        if (index < 0) {
            this.close();
            return false;
        }
        int length = this.source.length();
        int beginIndex = index;
        while (index < length) {
            char current = this.source.charAt(index);
            if (current == this.separator) {
                this.current = index == beginIndex ? "" : (this.trimEntries ? this.source.subSequence(beginIndex, index).trim().toString() : this.source.subSequence(beginIndex, index).toString());
                this.state = index + 2;
                return true;
            }
            ++index;
        }
        if (index == length) {
            this.current = index == beginIndex ? "" : (this.trimEntries ? this.source.subSequence(beginIndex, index).trim().toString() : this.source.subSequence(beginIndex, index).toString());
            this.state = index + 2;
            return true;
        }
        this.close();
        return false;
    }
}

