/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.util.lang.IStringSpan;

final class CharKeepEmptySplitIterator3
extends AbstractIterator<String> {
    private final IStringSpan source;
    private final char separator0;
    private final char separator1;
    private final char separator2;
    private final boolean trimEntries;

    CharKeepEmptySplitIterator3(IStringSpan source, char separator0, char separator1, char separator2, boolean trimEntries) {
        assert (source != null);
        this.source = source;
        this.separator0 = separator0;
        this.separator1 = separator1;
        this.separator2 = separator2;
        this.trimEntries = trimEntries;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharKeepEmptySplitIterator3(this.source, this.separator0, this.separator1, this.separator2, this.trimEntries);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        if (index < 0) {
            this.close();
            return false;
        }
        int length = this.source.length();
        int beginIndex = index;
        while (index < length) {
            char current = this.source.charAt(index);
            if (current == this.separator0 || current == this.separator1 || current == this.separator2) {
                this.current = index == beginIndex ? "" : (this.trimEntries ? this.source.subSequence(beginIndex, index).trim().toString() : this.source.subSequence(beginIndex, index).toString());
                this.state = index + 2;
                return true;
            }
            ++index;
        }
        if (index == length) {
            this.current = index == beginIndex ? "" : (this.trimEntries ? this.source.subSequence(beginIndex, index).trim().toString() : this.source.subSequence(beginIndex, index).toString());
            this.state = index + 2;
            return true;
        }
        this.close();
        return false;
    }
}

