/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.util.Strings;
import com.bestvike.linq.util.lang.IStringSpan;

final class CharOmitEmptySplitIterator1
extends AbstractIterator<String> {
    private final IStringSpan source;
    private final char separator;
    private final boolean trimEntries;

    CharOmitEmptySplitIterator1(IStringSpan source, char separator, boolean trimEntries) {
        assert (!Strings.isNullOrEmpty(source));
        this.source = source;
        this.separator = separator;
        this.trimEntries = trimEntries;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharOmitEmptySplitIterator1(this.source, this.separator, this.trimEntries);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        int index = this.state - 1;
        int length = this.source.length();
        while (index < length) {
            char tail;
            char head = this.source.charAt(index);
            if (head == this.separator) {
                ++index;
                continue;
            }
            int beginIndex = index++;
            while (index < length && (tail = this.source.charAt(index)) != this.separator) {
                ++index;
            }
            IStringSpan span = this.source.subSequence(beginIndex, index);
            if (this.trimEntries && (span = span.trim()).length() == 0) {
                ++index;
                continue;
            }
            this.current = span.toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }
}

