/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.enumerable.ProbabilisticMap;
import com.bestvike.linq.util.Strings;
import com.bestvike.linq.util.lang.IStringSpan;

final class CharOmitEmptySplitIteratorN
extends AbstractIterator<String> {
    private final IStringSpan source;
    private final char[] separators;
    private final boolean trimEntries;
    private ProbabilisticMap charMap;

    CharOmitEmptySplitIteratorN(IStringSpan source, char[] separators, boolean trimEntries) {
        assert (!Strings.isNullOrEmpty(source));
        assert (separators != null && separators.length > 3);
        this.source = source;
        this.separators = separators;
        this.trimEntries = trimEntries;
    }

    @Override
    public AbstractIterator<String> clone() {
        return new CharOmitEmptySplitIteratorN(this.source, this.separators, this.trimEntries);
    }

    @Override
    public boolean moveNext() {
        if (this.state == -1) {
            return false;
        }
        if (this.state == 1) {
            this.charMap = new ProbabilisticMap(this.separators);
        }
        int index = this.state - 1;
        int length = this.source.length();
        while (index < length) {
            char tail;
            char head = this.source.charAt(index);
            if (this.charMap.contains(head)) {
                ++index;
                continue;
            }
            int beginIndex = index++;
            while (index < length && !this.charMap.contains(tail = this.source.charAt(index))) {
                ++index;
            }
            IStringSpan span = this.source.subSequence(beginIndex, index);
            if (this.trimEntries && (span = span.trim()).length() == 0) {
                ++index;
                continue;
            }
            this.current = span.toString();
            this.state = index + 1;
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public void close() {
        this.charMap = null;
        super.close();
    }
}

