/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.enumerable.ChunkIterator;
import com.bestvike.linq.exception.ExceptionArgument;
import com.bestvike.linq.exception.ThrowHelper;

public final class Chunk {
    private Chunk() {
    }

    public static <TSource> IEnumerable<TSource[]> chunk(IEnumerable<TSource> source, int size, Class<TSource> clazz) {
        if (source == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.source);
        }
        if (size < 1) {
            ThrowHelper.throwArgumentOutOfRangeException(ExceptionArgument.size);
        }
        if (clazz == null) {
            ThrowHelper.throwArgumentNullException(ExceptionArgument.clazz);
        }
        return new ChunkIterator<TSource>(source, size, clazz);
    }
}

