/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.enumerable;

import com.bestvike.linq.IEnumerable;
import com.bestvike.linq.IEnumerator;
import com.bestvike.linq.enumerable.AbstractIterator;
import com.bestvike.linq.util.ArrayUtils;
import java.util.Arrays;

final class ChunkIterator<TSource>
extends AbstractIterator<TSource[]> {
    private final IEnumerable<TSource> source;
    private final int size;
    private final Class<TSource> clazz;
    private IEnumerator<TSource> enumerator;

    ChunkIterator(IEnumerable<TSource> source, int size, Class<TSource> clazz) {
        this.source = source;
        this.size = size;
        this.clazz = clazz;
    }

    @Override
    public AbstractIterator<TSource[]> clone() {
        return new ChunkIterator<TSource>(this.source, this.size, this.clazz);
    }

    @Override
    public boolean moveNext() {
        switch (this.state) {
            case 1: {
                this.enumerator = this.source.enumerator();
                this.state = 2;
            }
            case 2: {
                int chunkSize;
                if (!this.enumerator.moveNext()) {
                    this.close();
                    return false;
                }
                TSource[] chunk = ArrayUtils.newInstance(this.clazz, this.size);
                chunk[0] = this.enumerator.current();
                for (chunkSize = 1; chunkSize < chunk.length && this.enumerator.moveNext(); ++chunkSize) {
                    chunk[chunkSize] = this.enumerator.current();
                }
                if (chunkSize == chunk.length) {
                    this.current = chunk;
                    return true;
                }
                this.current = Arrays.copyOf(chunk, chunkSize);
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.enumerator != null) {
            this.enumerator.close();
            this.enumerator = null;
        }
        super.close();
    }
}

